/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.xdebugger.attach.XDefaultLocalAttachGroup;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JavaAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final XLocalAttachDebugger ourAttachDebugger = new XLocalAttachDebugger(){

        @Override
        @NotNull
        public String getDebuggerDisplayName() {
            if ("Java Debugger" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Java Debugger";
        }

        @Override
        public void attachDebugSession(@NotNull Project project2, @NotNull ProcessInfo processInfo) {
            if (project2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (processInfo == null) {
                1.$$$reportNull$$$0(2);
            }
            Pair address = JavaAttachDebuggerProvider.getAttachAddress(processInfo);
            assert (address != null);
            String name2 = JavaAttachDebuggerProvider.getAttachString((Pair<String, Integer>)address);
            RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project2).createRunConfiguration(name2, Objects.requireNonNull(ConfigurationTypeUtil.findConfigurationType((String)"Remote")).getConfigurationFactories()[0]);
            RunConfiguration remoteConfiguration = runSettings.getConfiguration();
            String host = address.first != null && !"*".equals(address.first) ? (String)address.first : "127.0.0.1";
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, String.class, (String)"HOST", (Object)host);
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, String.class, (String)"PORT", (Object)String.valueOf(address.second));
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, Boolean.TYPE, (String)"USE_SOCKET_TRANSPORT", (Object)true);
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, Boolean.TYPE, (String)"SERVER_MODE", (Object)false);
            ProgramRunnerUtil.executeConfiguration(runSettings, DefaultDebugExecutor.getDebugExecutorInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final XLocalAttachGroup ourAttachGroup = new XDefaultLocalAttachGroup(){

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        @NotNull
        public String getGroupName() {
            if ("Java" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "Java";
        }

        @Override
        @NotNull
        public String getProcessDisplayText(@NotNull Project project2, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
            if (project2 == null) {
                2.$$$reportNull$$$0(1);
            }
            if (info == null) {
                2.$$$reportNull$$$0(2);
            }
            if (dataHolder == null) {
                2.$$$reportNull$$$0(3);
            }
            Pair address = JavaAttachDebuggerProvider.getAttachAddress(info);
            assert (address != null);
            String string = StringUtil.notNullize((String)((String)ArrayUtil.getLastElement((Object[])info.getCommandLine().split(" ")))) + " (" + JavaAttachDebuggerProvider.getAttachString((Pair<String, Integer>)address) + ')';
            if (string == null) {
                2.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessDisplayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessDisplayText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private static String getAttachString(Pair<String, Integer> address) {
        return StringUtil.notNullize((String)((String)address.first)) + ":" + address.second;
    }

    @Override
    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        XLocalAttachGroup xLocalAttachGroup = ourAttachGroup;
        if (xLocalAttachGroup == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return xLocalAttachGroup;
    }

    @Override
    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        Pair<String, Integer> address;
        if (project2 == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (processInfo == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (contextHolder == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if ((address = JavaAttachDebuggerProvider.getAttachAddress(processInfo)) != null) {
            List<XLocalAttachDebugger> list2 = Collections.singletonList(ourAttachDebugger);
            if (list2 == null) {
                JavaAttachDebuggerProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<XLocalAttachDebugger> list3 = Collections.emptyList();
        if (list3 == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static Pair<String, Integer> getAttachAddress(ProcessInfo processInfo) {
        return DebugAttachDetector.getAttachAddress(ParametersListUtil.parse((String)processInfo.getCommandLine()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

