/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            TextWithImportsImpl.$$$reportNull$$$0(0);
        }
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text2 = expression2.getText();
        PsiFile containingFile = expression2.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text2;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text2);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text2, @NotNull String imports2, @Nullable FileType fileType) {
        if (text2 == null) {
            TextWithImportsImpl.$$$reportNull$$$0(1);
        }
        if (imports2 == null) {
            TextWithImportsImpl.$$$reportNull$$$0(2);
        }
        this.myKind = kind2;
        this.myText = text2;
        this.myImports = imports2;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text2) {
        if (text2 == null) {
            TextWithImportsImpl.$$$reportNull$$$0(3);
        }
        this.myKind = kind2;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text2);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        String string = this.myImports;
        if (string == null) {
            TextWithImportsImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result2 = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result2 = result2 + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result2 = result2 + '\r' + this.myFileType.getName();
        }
        return result2;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text2) {
        if (text2 != null && !text2.getText().isEmpty()) {
            return new XExpressionImpl(text2.getText(), LanguageUtil.getFileTypeLanguage((FileType)text2.getFileType()), StringUtil.nullize((String)text2.getImports()), TextWithImportsImpl.getMode(text2.getKind()));
        }
        return null;
    }

    private static EvaluationMode getMode(CodeFragmentKind kind2) {
        switch (kind2) {
            case EXPRESSION: {
                return EvaluationMode.EXPRESSION;
            }
            case CODE_BLOCK: {
                return EvaluationMode.CODE_FRAGMENT;
            }
        }
        throw new IllegalStateException("Unknown kind " + kind2);
    }

    private static CodeFragmentKind getKind(EvaluationMode mode) {
        switch (mode) {
            case EXPRESSION: {
                return CodeFragmentKind.EXPRESSION;
            }
            case CODE_FRAGMENT: {
                return CodeFragmentKind.CODE_BLOCK;
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getCustomInfo() == null && expression2.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression(), StringUtil.notNullize((String)expression2.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression2.getLanguage()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

