/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldEvaluator
implements Evaluator {
    private final Evaluator myObjectEvaluator;
    private final TargetClassFilter myTargetClassFilter;
    private final String myFieldName;
    private Object myEvaluatedQualifier;
    private Field myEvaluatedField;

    public FieldEvaluator(Evaluator objectEvaluator, TargetClassFilter filter2, @NonNls String fieldName) {
        this.myObjectEvaluator = objectEvaluator;
        this.myFieldName = fieldName;
        this.myTargetClassFilter = filter2;
    }

    @NotNull
    public static TargetClassFilter createClassFilter(@Nullable PsiType psiType) {
        if (psiType == null || psiType instanceof PsiArrayType) {
            TargetClassFilter targetClassFilter = TargetClassFilter.ALL;
            if (targetClassFilter == null) {
                FieldEvaluator.$$$reportNull$$$0(0);
            }
            return targetClassFilter;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass != null) {
            TargetClassFilter targetClassFilter = FieldEvaluator.createClassFilter(psiClass);
            if (targetClassFilter == null) {
                FieldEvaluator.$$$reportNull$$$0(1);
            }
            return targetClassFilter;
        }
        FQNameClassFilter fQNameClassFilter = new FQNameClassFilter(psiType.getCanonicalText());
        if (fQNameClassFilter == null) {
            FieldEvaluator.$$$reportNull$$$0(2);
        }
        return fQNameClassFilter;
    }

    public static TargetClassFilter createClassFilter(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            return TargetClassFilter.ALL;
        }
        if (PsiUtil.isLocalClass((PsiClass)psiClass)) {
            return new LocalClassFilter(psiClass.getName());
        }
        String name2 = JVMNameUtil.getNonAnonymousClassName(psiClass);
        return name2 != null ? new FQNameClassFilter(name2) : TargetClassFilter.ALL;
    }

    @Nullable
    private Field findField(@Nullable Type t) {
        if (t instanceof ClassType) {
            ClassType cls = (ClassType)t;
            if (this.myTargetClassFilter.acceptClass(cls)) {
                return cls.fieldByName(this.myFieldName);
            }
            for (InterfaceType interfaceType : cls.interfaces()) {
                Field field = this.findField(interfaceType);
                if (field == null) continue;
                return field;
            }
            return this.findField(cls.superclass());
        }
        if (t instanceof InterfaceType) {
            InterfaceType iface = (InterfaceType)t;
            if (this.myTargetClassFilter.acceptClass(iface)) {
                return iface.fieldByName(this.myFieldName);
            }
            for (InterfaceType interfaceType : iface.superinterfaces()) {
                Field field = this.findField(interfaceType);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        this.myEvaluatedField = null;
        this.myEvaluatedQualifier = null;
        Object object = this.myObjectEvaluator.evaluate(context);
        return this.evaluateField(object, context);
    }

    private Object evaluateField(Object object, EvaluationContextImpl context) throws EvaluateException {
        if (object instanceof ReferenceType) {
            ReferenceType refType = (ReferenceType)object;
            Field field = this.findField(refType);
            if (field == null || !field.isStatic()) {
                field = refType.fieldByName(this.myFieldName);
            }
            if (field == null || !field.isStatic()) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.field", (Object[])new Object[]{this.myFieldName}));
            }
            this.myEvaluatedField = field;
            this.myEvaluatedQualifier = refType;
            return refType.getValue(field);
        }
        if (object instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)object;
            ReferenceType refType = objRef.referenceType();
            if (!(refType instanceof ClassType) && !(refType instanceof ArrayType)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.class.or.array.expected", (Object[])new Object[]{this.myFieldName}));
            }
            if (objRef instanceof ArrayReference && "length".equals(this.myFieldName)) {
                return DebuggerUtilsEx.createValue(context.getDebugProcess().getVirtualMachineProxy(), "int", ((ArrayReference)objRef).length());
            }
            Field field = this.findField(refType);
            if (field == null) {
                field = refType.fieldByName(this.myFieldName);
            }
            if (field == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.field", (Object[])new Object[]{this.myFieldName}));
            }
            this.myEvaluatedQualifier = field.isStatic() ? refType : objRef;
            this.myEvaluatedField = field;
            return field.isStatic() ? refType.getValue(field) : objRef.getValue(field);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.field", (Object[])new Object[]{this.myFieldName}));
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.myEvaluatedField != null && (this.myEvaluatedQualifier instanceof ClassType || this.myEvaluatedQualifier instanceof ObjectReference)) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return FieldEvaluator.this.myEvaluatedQualifier instanceof ObjectReference;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value2) throws ClassNotLoadedException, InvalidTypeException {
                    if (FieldEvaluator.this.myEvaluatedQualifier instanceof ReferenceType) {
                        ClassType classType = (ClassType)FieldEvaluator.this.myEvaluatedQualifier;
                        classType.setValue(FieldEvaluator.this.myEvaluatedField, value2);
                    } else {
                        ObjectReference objRef = (ObjectReference)FieldEvaluator.this.myEvaluatedQualifier;
                        objRef.setValue(FieldEvaluator.this.myEvaluatedField, value2);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    return FieldEvaluator.this.myEvaluatedField.type();
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    if (FieldEvaluator.this.myEvaluatedQualifier instanceof ObjectReference) {
                        return new FieldDescriptorImpl(project2, (ObjectReference)FieldEvaluator.this.myEvaluatedQualifier, FieldEvaluator.this.myEvaluatedField);
                    }
                    return null;
                }
            };
        }
        return modifier;
    }

    public String toString() {
        return "field " + this.myFieldName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/expression/FieldEvaluator", "createClassFilter"));
    }

    private static final class LocalClassFilter
    implements TargetClassFilter {
        private final String myLocalClassShortName;

        private LocalClassFilter(String localClassShortName) {
            this.myLocalClassShortName = localClassShortName;
        }

        @Override
        public boolean acceptClass(ReferenceType refType) {
            String name2 = refType.name();
            int index = name2.lastIndexOf(this.myLocalClassShortName);
            if (index < 0) {
                return false;
            }
            for (int idx = index - 1; idx >= 0; --idx) {
                char ch = name2.charAt(idx);
                if (ch == '$') {
                    return idx < index - 1;
                }
                if (Character.isDigit(ch)) continue;
                return false;
            }
            return false;
        }
    }

    private static final class FQNameClassFilter
    implements TargetClassFilter {
        private final String myQName;

        private FQNameClassFilter(String qName) {
            this.myQName = qName;
        }

        @Override
        public boolean acceptClass(ReferenceType refType) {
            return refType.name().equals(this.myQName);
        }
    }

    public static interface TargetClassFilter {
        public static final TargetClassFilter ALL = refType -> true;

        public boolean acceptClass(ReferenceType var1);
    }
}

