/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapManager
extends AbstractProjectComponent {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap();
    private static final String CLASS_EXTENSION = ".class";

    public HotSwapManager(Project project2, DebuggerManagerEx manager) {
        super(project2);
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session2) {
                HotSwapManager.this.myTimeStamps.put(session2, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession session2) {
                HotSwapManager.this.myTimeStamps.remove(session2);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("HotSwapManager" == null) {
            HotSwapManager.$$$reportNull$$$0(0);
        }
        return "HotSwapManager";
    }

    private long getTimeStamp(DebuggerSession session2) {
        Long tStamp = this.myTimeStamps.get(session2);
        return tStamp != null ? tStamp : 0L;
    }

    void setTimeStamp(DebuggerSession session2, long tStamp) {
        this.myTimeStamps.put(session2, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession session2, HotSwapProgress progress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long timeStamp = this.getTimeStamp(session2);
        HashMap modifiedClasses = new HashMap();
        ArrayList outputRoots = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            List allDirs = OrderEnumerator.orderEntries((Project)this.myProject).withoutSdk().withoutLibraries().getPathsList().getRootDirs();
            for (VirtualFile dir : allDirs) {
                outputRoots.add(new File(dir.getPath()));
            }
        });
        for (File root : outputRoots) {
            String rootPath = FileUtil.toCanonicalPath((String)root.getPath());
            HotSwapManager.collectModifiedClasses(root, rootPath, rootPath + "/", (Map<String, HotSwapFile>)modifiedClasses, progress, timeStamp);
        }
        return modifiedClasses;
    }

    private static boolean collectModifiedClasses(File file2, String filePath, String rootPath, Map<String, HotSwapFile> container, HotSwapProgress progress, long timeStamp) {
        if (progress.isCancelled()) {
            return false;
        }
        File[] files = file2.listFiles();
        if (files != null) {
            for (File child : files) {
                if (HotSwapManager.collectModifiedClasses(child, filePath + "/" + child.getName(), rootPath, container, progress, timeStamp)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)filePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)CLASS_EXTENSION)) && file2.lastModified() > timeStamp) {
            progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
            String qualifiedName = filePath.substring(rootPath.length(), filePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
            container.put(qualifiedName, new HotSwapFile(file2));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project2) {
        return (HotSwapManager)((Object)project2.getComponent(HotSwapManager.class));
    }

    private void reloadClasses(DebuggerSession session2, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session2, progress).reloadClasses(classesToReload);
        if (progress.isCancelled()) {
            session2.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(session2, newSwapTime);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<DebuggerSession> sessions, Map<String, List<String>> generatedPaths) {
        java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>> result2 = new java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> sessionWithStamps = new ArrayList<Pair>();
        for (DebuggerSession debuggerSession : sessions) {
            sessionWithStamps.add(new Pair((Object)debuggerSession, (Object)HotSwapManager.getInstance(debuggerSession.getProject()).getTimeStamp(debuggerSession)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File root = new File((String)entry.getKey());
            for (String relativePath : (List)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)relativePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)relativePath, (String)CLASS_EXTENSION))) continue;
                String qualifiedName = relativePath.substring(0, relativePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
                HotSwapFile hotswapFile = new HotSwapFile(new File(root, relativePath));
                long fileStamp = hotswapFile.file.lastModified();
                for (Pair pair2 : sessionWithStamps) {
                    DebuggerSession session3 = (DebuggerSession)pair2.first;
                    if (fileStamp <= (Long)pair2.second) continue;
                    result2.computeIfAbsent(session3, k -> new java.util.HashMap()).put(qualifiedName, hotswapFile);
                }
            }
        }
        return result2;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<DebuggerSession> sessions, final HotSwapProgress swapProgress) {
        HashMap modifiedClasses = new HashMap();
        MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(() -> scanClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl((Map)modifiedClasses){
                final /* synthetic */ Map val$modifiedClasses;
                {
                    this.val$modifiedClasses = map;
                }

                @Override
                protected void action() throws Exception {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, swapProgress);
                    if (!sessionClasses.isEmpty()) {
                        this.val$modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession session2 : sessions) {
                session2.setModifiedClassesScanRequired(true);
            }
            return new HashMap();
        }
        return modifiedClasses;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgress reloadClassesProgress) {
        MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(() -> reloadClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/HotSwapManager", "getComponentName"));
    }
}

