/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import org.jetbrains.annotations.NotNull;

public class GeneratedLocation
implements Location {
    private final DebugProcessImpl myDebugProcess;
    private final int myLineNumber;
    private final ReferenceType myReferenceType;
    private final Method myMethod;

    public GeneratedLocation(DebugProcessImpl debugProcess, String className, String methodName, int lineNumber) {
        this.myDebugProcess = debugProcess;
        this.myLineNumber = lineNumber;
        this.myReferenceType = (ReferenceType)ContainerUtil.getFirstItem(this.myDebugProcess.getVirtualMachineProxy().classesByName(className));
        this.myMethod = (Method)ContainerUtil.getFirstItem(this.myReferenceType.methodsByName(methodName));
    }

    @Override
    public ReferenceType declaringType() {
        return this.myReferenceType;
    }

    @Override
    public Method method() {
        return this.myMethod;
    }

    @Override
    public long codeIndex() {
        throw new IllegalStateException();
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourceName(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourcePath(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public int lineNumber() {
        return this.myLineNumber;
    }

    @Override
    public int lineNumber(String s) {
        return this.myLineNumber;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.myDebugProcess.getVirtualMachineProxy().getVirtualMachine();
    }

    @Override
    public int compareTo(@NotNull Location o) {
        if (o == null) {
            GeneratedLocation.$$$reportNull$$$0(0);
        }
        throw new IllegalStateException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/jdi/GeneratedLocation", "compareTo"));
    }
}

