/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadReferenceProxyImpl");
    private String myName;
    private int myFrameCount = -1;
    private final LinkedList<StackFrameProxyImpl> myFramesFromBottom = new LinkedList();
    private List<StackFrameProxyImpl> myFrames = null;
    private ThreadGroupReferenceProxyImpl myThreadGroupProxy;
    public static final Comparator<ThreadReferenceProxyImpl> ourComparator = (th1, th2) -> {
        int res = Comparing.compare((boolean)th2.isSuspended(), (boolean)th1.isSuspended());
        if (res == 0) {
            return th1.name().compareToIgnoreCase(th2.name());
        }
        return res;
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadReference threadReference) {
        super(virtualMachineProxy, threadReference);
    }

    public ThreadReference getThreadReference() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (ThreadReference)this.getObjectReference();
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(0);
        }
        return virtualMachineProxyImpl;
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            try {
                this.myName = this.getThreadReference().name();
            }
            catch (ObjectCollectedException ignored) {
                this.myName = "";
            }
            catch (IllegalThreadStateException ignored) {
                this.myName = "zombie";
            }
        }
        return this.myName;
    }

    public int getSuspendCount() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException ignored) {
            return 0;
        }
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().suspend();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
    }

    @Override
    @NonNls
    public String toString() {
        try {
            return this.name() + ": " + DebuggerUtilsEx.getThreadStatusText(this.status());
        }
        catch (ObjectCollectedException ignored) {
            return "[thread collected]";
        }
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadRef = this.getThreadReference();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before resume" + threadRef);
        }
        this.getVirtualMachineProxy().clearCaches();
        try {
            threadRef.resume();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myName = null;
        this.myFrames = null;
        this.myFrameCount = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException | IllegalThreadStateException e) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myThreadGroupProxy == null) {
            ThreadGroupReference threadGroupRef;
            try {
                threadGroupRef = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException ignored) {
                threadGroupRef = null;
            }
            this.myThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupRef);
        }
        return this.myThreadGroupProxy;
    }

    public int frameCount() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameCount == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.myFrameCount = threadReference.frameCount();
            }
            catch (ObjectCollectedException ignored) {
                this.myFrameCount = 0;
            }
            catch (IncompatibleThreadStateException e) {
                boolean isSuspended;
                try {
                    isSuspended = threadReference.isSuspended();
                }
                catch (Throwable ignored) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                if (!isSuspended) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                this.myFrameCount = 0;
            }
            catch (InternalException e) {
                LOG.info((Throwable)e);
                this.myFrameCount = 0;
            }
        }
        return this.myFrameCount;
    }

    @NotNull
    public List<StackFrameProxyImpl> forceFrames() throws EvaluateException {
        block7: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ThreadReference threadRef = this.getThreadReference();
            try {
                this.checkValid();
                if (this.myFrames != null) break block7;
                try {
                    List<StackFrame> frames = threadRef.frames();
                    this.myFrameCount = frames.size();
                    this.myFrames = new ArrayList<StackFrameProxyImpl>(this.myFrameCount);
                    this.myFramesFromBottom.clear();
                    int idx = 0;
                    for (StackFrame frame : frames) {
                        StackFrameProxyImpl frameProxy = new StackFrameProxyImpl(this, frame, this.myFrameCount - idx);
                        this.myFrames.add(frameProxy);
                        this.myFramesFromBottom.addFirst(frameProxy);
                        ++idx;
                    }
                }
                catch (IncompatibleThreadStateException | InternalException e) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
            }
            catch (ObjectCollectedException ignored) {
                List<StackFrameProxyImpl> list2 = Collections.emptyList();
                if (list2 == null) {
                    ThreadReferenceProxyImpl.$$$reportNull$$$0(1);
                }
                return list2;
            }
        }
        List<StackFrameProxyImpl> list3 = this.myFrames;
        if (list3 == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    public List<StackFrameProxyImpl> frames() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadRef = this.getThreadReference();
        try {
            this.checkValid();
            if (this.myFrames == null) {
                this.checkFrames(threadRef);
                this.myFrames = ContainerUtil.reverse(new ArrayList(this.myFramesFromBottom.subList(0, this.frameCount())));
            }
        }
        catch (ObjectCollectedException ignored) {
            List<StackFrameProxyImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                ThreadReferenceProxyImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<StackFrameProxyImpl> list3 = this.myFrames;
        if (list3 == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(4);
        }
        return list3;
    }

    private void checkFrames(@NotNull ThreadReference threadRef) throws EvaluateException {
        if (threadRef == null) {
            ThreadReferenceProxyImpl.$$$reportNull$$$0(5);
        }
        int frameCount = this.frameCount();
        if (this.myFramesFromBottom.size() < frameCount) {
            List<StackFrame> frames;
            try {
                frames = threadRef.frames(0, frameCount - this.myFramesFromBottom.size());
            }
            catch (IncompatibleThreadStateException | InternalException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            int index = this.myFramesFromBottom.size() + 1;
            ListIterator<StackFrame> iterator = frames.listIterator(frameCount - this.myFramesFromBottom.size());
            while (iterator.hasPrevious()) {
                this.myFramesFromBottom.add(new StackFrameProxyImpl(this, iterator.previous(), index));
                ++index;
            }
        } else {
            while (this.myFramesFromBottom.size() > frameCount) {
                this.myFramesFromBottom.removeLast();
            }
        }
    }

    public StackFrameProxyImpl frame(int i) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
            this.checkFrames(threadReference);
            int frameCount = this.frameCount();
            if (frameCount == 0) {
                return null;
            }
            return this.myFramesFromBottom.get(frameCount - i - 1);
        }
        catch (ObjectCollectedException | IllegalThreadStateException ignored) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrame) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().popFrames(stackFrame.getStackFrame());
        }
        catch (InvalidStackFrameException | ObjectCollectedException runtimeException) {
        }
        catch (InternalException e) {
            if (e.errorCode() == 32) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"drop.frame.error.no.information", (Object[])new Object[0]));
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void forceEarlyReturn(Value value2) throws ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().forceEarlyReturn(value2);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException e) {
            LOG.info((Throwable)e);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getThreadReference().isAtBreakpoint();
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forceFrames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "frames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

