/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.CheckingResultImpl;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.Value;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionCheckerImpl
implements ConditionChecker {
    private final DebugProcessImpl myDebugProcess;
    private final MyCachedEvaluator myEvaluator;
    private final AtomicReference<CheckingResult> myResultReference;

    public ConditionCheckerImpl(@NotNull DebugProcessImpl debugProcess, @Nullable XExpression expression2, @NotNull String className) {
        if (debugProcess == null) {
            ConditionCheckerImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ConditionCheckerImpl.$$$reportNull$$$0(1);
        }
        this.myResultReference = new AtomicReference();
        this.myDebugProcess = debugProcess;
        this.myEvaluator = new MyCachedEvaluator(this.myDebugProcess.getProject(), className);
        this.myEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(expression2));
    }

    @Override
    public CheckingResult check(@NotNull Value ref) {
        if (ref == null) {
            ConditionCheckerImpl.$$$reportNull$$$0(2);
        }
        this.myDebugProcess.getManagerThread().invokeAndWait(new MyCheckerCommand(ref));
        return this.myResultReference.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/filtering/ConditionCheckerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyCachedEvaluator
    extends CachedEvaluator {
        private final Project myProject;
        private final String myClassName;

        public MyCachedEvaluator(@NotNull Project project2, @NotNull String className) {
            if (project2 == null) {
                MyCachedEvaluator.$$$reportNull$$$0(0);
            }
            if (className == null) {
                MyCachedEvaluator.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myClassName = className;
        }

        ExpressionEvaluator getEvaluator() throws EvaluateException {
            return this.getEvaluator(this.myProject);
        }

        @Override
        protected String getClassName() {
            return this.myClassName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/filtering/ConditionCheckerImpl$MyCachedEvaluator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCheckerCommand
    extends DebuggerContextCommandImpl {
        private final Value myReference;

        protected MyCheckerCommand(Value ref) {
            if (ref == null) {
                MyCheckerCommand.$$$reportNull$$$0(0);
            }
            super(ConditionCheckerImpl.this.myDebugProcess.getDebuggerContext());
            this.myReference = ref;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.LOWEST;
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                MyCheckerCommand.$$$reportNull$$$0(1);
            }
            try {
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy(), this.myReference);
                ConditionCheckerImpl.this.myResultReference.set(DebuggerUtilsEx.evaluateBoolean(ConditionCheckerImpl.this.myEvaluator.getEvaluator(), evaluationContext) ? CheckingResultImpl.SUCCESS : CheckingResultImpl.FAIL);
            }
            catch (EvaluateException e) {
                ConditionCheckerImpl.this.myResultReference.set(CheckingResultImpl.error(e.getMessage()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/filtering/ConditionCheckerImpl$MyCheckerCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

