/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class SingleAlarmWithMutableDelay {
    private final Alarm myAlarm;
    private final Task myTask;
    private volatile int myDelayMillis;

    public SingleAlarmWithMutableDelay(@NotNull Task task, @NotNull Disposable parentDisposable) {
        if (task == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(1);
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.myTask = task;
    }

    public void setDelay(int millis) {
        this.myDelayMillis = millis;
    }

    public void cancelAndRequest(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(2);
        }
        if (!this.myAlarm.isDisposed()) {
            this.cancelAllRequests();
            this.addRequest(() -> {
                if (suspendContext == null) {
                    SingleAlarmWithMutableDelay.$$$reportNull$$$0(4);
                }
                this.myTask.run(suspendContext);
            });
        }
    }

    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    private void addRequest(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(3);
        }
        this.myAlarm.addRequest(runnable2, this.myDelayMillis);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelAndRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$cancelAndRequest$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Task {
        public void run(@NotNull SuspendContextImpl var1);
    }
}

