/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaLineBreakpointTypeBase<P extends JavaBreakpointProperties>
extends XLineBreakpointType<P> {
    public JavaLineBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(1);
        }
        super(id, title);
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public final boolean isSuspendThreadSupported() {
        return true;
    }

    @Nullable
    public final XBreakpointCustomPropertiesPanel<XLineBreakpoint<P>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(2);
        }
        return new JavaBreakpointFiltersPanel(project2);
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<P> breakpoint, @NotNull Project project2) {
        if (breakpoint == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(4);
        }
        return new JavaDebuggerEditorsProvider();
    }

    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        BreakpointWithHighlighter javaBreakpoint = (BreakpointWithHighlighter)BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null) {
            return javaBreakpoint.getDescription();
        }
        return super.getDisplayText(breakpoint);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        PsiFile psiFile;
        if (file2 == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            JavaLineBreakpointTypeBase.$$$reportNull$$$0(6);
        }
        if ((psiFile = PsiManager.getInstance((Project)project2).findFile(file2)) == null || psiFile.getViewProvider().getFileType() == StdFileTypes.XHTML) {
            return false;
        }
        if (!StdFileTypes.CLASS.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        Ref result2 = Ref.create();
        XDebuggerUtil.getInstance().iterateLine(project2, document, line, element -> {
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiImportStatementBase.class, PsiPackageStatement.class}) != null) {
                return true;
            }
            PsiElement parent = element;
            while (element != null) {
                if (element instanceof PsiModifierList) {
                    element = element.getParent();
                    continue;
                }
                int offset = element.getTextOffset();
                if (offset >= 0 && document.getLineNumber(offset) != line) break;
                parent = element;
                element = element.getParent();
            }
            if (parent instanceof PsiMethod) {
                PsiStatement[] statements;
                PsiCodeBlock body2;
                if (parent.getTextRange().getEndOffset() >= document.getLineEndOffset(line) && (body2 = ((PsiMethod)parent).getBody()) != null && (statements = body2.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == line) {
                    result2.set(JavaLineBreakpointType.class);
                }
                if (result2.isNull()) {
                    result2.set(JavaMethodBreakpointType.class);
                }
            } else if (parent instanceof PsiField) {
                if (result2.isNull()) {
                    result2.set(JavaFieldBreakpointType.class);
                }
            } else {
                result2.set(JavaLineBreakpointType.class);
            }
            return true;
        });
        return result2.get() == ((Object)((Object)this)).getClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomRightPropertiesPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

