/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private Collection<ClassObject> myCompiledClasses;

    public CompilingEvaluatorImpl(@NotNull Project project2, @NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (project2 == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(1);
        }
        if (data == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(2);
        }
        super(project2, context, data);
    }

    @Override
    @NotNull
    protected Collection<ClassObject> compile(@Nullable JavaSdkVersion debuggeeVersion) throws EvaluateException {
        if (this.myCompiledClasses == null) {
            Module module2 = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiContext));
            ArrayList<String> options = new ArrayList<String>();
            options.add("-encoding");
            options.add("UTF-8");
            ArrayList<File> platformClasspath = new ArrayList<File>();
            ArrayList<File> classpath = new ArrayList<File>();
            AnnotationProcessingConfiguration profile2 = null;
            if (module2 != null) {
                assert (this.myProject.equals(module2.getProject())) : module2 + " is from another project";
                profile2 = CompilerConfiguration.getInstance((Project)this.myProject).getAnnotationProcessingConfiguration(module2);
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
                for (String s : rootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                    classpath.add(new File(s));
                }
                for (String s : rootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                    platformClasspath.add(new File(s));
                }
            }
            JavaBuilder.addAnnotationProcessingOptions(options, profile2);
            Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getJavacRuntimeSdk(this.myProject);
            JavaSdkVersion buildRuntimeVersion = (JavaSdkVersion)runtime.getSecond();
            if (buildRuntimeVersion != null && debuggeeVersion != null) {
                JavaSdkVersion minVersion = buildRuntimeVersion.ordinal() > debuggeeVersion.ordinal() ? debuggeeVersion : buildRuntimeVersion;
                String sourceOption = CompilingEvaluatorImpl.getSourceOption(minVersion.getMaxLanguageLevel());
                options.add("-source");
                options.add(sourceOption);
                options.add("-target");
                options.add(sourceOption);
            }
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            File sourceFile = null;
            try {
                sourceFile = this.generateTempSourceFile(compilerManager.getJavacCompilerWorkingDir());
                File srcDir = sourceFile.getParentFile();
                List sourcePath = Collections.emptyList();
                Set<File> sources = Collections.singleton(sourceFile);
                this.myCompiledClasses = compilerManager.compileJavaCode(options, platformClasspath, classpath, Collections.emptyList(), sourcePath, sources, srcDir);
            }
            catch (CompilationException e) {
                StringBuilder res = new StringBuilder("Compilation failed:\n");
                for (CompilationException.Message m : e.getMessages()) {
                    if (m.getCategory() != CompilerMessageCategory.ERROR) continue;
                    res.append(m.getText()).append("\n");
                }
                throw new EvaluateException(res.toString());
            }
            catch (Exception e) {
                throw new EvaluateException(e.getMessage());
            }
            finally {
                if (sourceFile != null) {
                    FileUtil.delete((File)sourceFile);
                }
            }
        }
        Collection<ClassObject> collection = this.myCompiledClasses;
        if (collection == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private static String getSourceOption(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(4);
        }
        String string = "1." + Integer.valueOf(3 + languageLevel.ordinal());
        if (string == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private File generateTempSourceFile(File workingDir) throws IOException {
        Pair fileData = (Pair)ReadAction.compute(() -> {
            PsiFile file2 = this.myData.getGeneratedInnerClass().getContainingFile();
            return Pair.create((Object)file2.getName(), (Object)file2.getText());
        });
        if (fileData.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (fileData.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file2 = new File(workingDir, "debugger/src/" + (String)fileData.first);
        FileUtil.writeToFile((File)file2, (String)((String)fileData.second));
        return file2;
    }

    @Nullable
    public static ExpressionEvaluator create(@NotNull Project project2, @Nullable PsiElement psiContext, @NotNull Function<PsiElement, PsiCodeFragment> fragmentFactory) throws EvaluateException {
        if (project2 == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(6);
        }
        if (fragmentFactory == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(7);
        }
        if (Registry.is((String)"debugger.compiling.evaluator") && psiContext != null) {
            return (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                if (project2 == null) {
                    CompilingEvaluatorImpl.$$$reportNull$$$0(10);
                }
                if (fragmentFactory == null) {
                    CompilingEvaluatorImpl.$$$reportNull$$$0(11);
                }
                try {
                    ExtractLightMethodObjectHandler.ExtractedData data = ExtractLightMethodObjectHandler.extractLightMethodObject(project2, CompilingEvaluatorImpl.findPhysicalContext(psiContext), (PsiCodeFragment)fragmentFactory.apply(psiContext), CompilingEvaluatorImpl.getGeneratedClassName());
                    if (data != null) {
                        return new CompilingEvaluatorImpl(project2, psiContext, data);
                    }
                }
                catch (PrepareFailedException e) {
                    NodeDescriptorImpl.LOG.info((Throwable)e);
                }
                return null;
            });
        }
        return null;
    }

    @NotNull
    private static PsiElement findPhysicalContext(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(8);
        }
        while (!element.isPhysical() && (context = element.getContext()) != null) {
            element = context;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceOption";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhysicalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSourceOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPhysicalContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

