/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ArrayRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ArrayRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ArrayRenderer";
    public int START_INDEX = 0;
    public int END_INDEX = Integer.MAX_VALUE;
    public int ENTRIES_LIMIT = 100;
    private boolean myForced = false;

    public ArrayRenderer() {
        this.myProperties.setEnabled(true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Array";
    }

    @Override
    public void setName(String text2) {
        LOG.assertTrue(false);
    }

    @Override
    public ArrayRenderer clone() {
        return (ArrayRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        return ClassRenderer.calcLabel(descriptor2);
    }

    public void setForced(boolean forced) {
        this.myForced = forced;
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        NodeManagerImpl nodeManager = (NodeManagerImpl)builder.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
        ArrayReference array = (ArrayReference)value2;
        int arrayLength = array.length();
        if (arrayLength > 0) {
            int idx;
            if (!this.myForced) {
                builder.initChildrenArrayRenderer(this, arrayLength);
            }
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            int added = 0;
            boolean hiddenNulls = false;
            int end = Math.min(arrayLength - 1, this.END_INDEX);
            if (arrayLength > this.START_INDEX) {
                for (idx = this.START_INDEX; idx <= end; ++idx) {
                    if (ViewsGeneralSettings.getInstance().HIDE_NULL_ARRAY_ELEMENTS && ArrayRenderer.elementIsNull(array, idx)) {
                        hiddenNulls = true;
                        continue;
                    }
                    DebuggerTreeNodeImpl arrayItemNode = nodeManager.createNode(descriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), array, idx), evaluationContext);
                    builder.addChildren(Collections.singletonList(arrayItemNode), false);
                    if (++added >= this.ENTRIES_LIMIT) break;
                }
            }
            builder.addChildren(Collections.emptyList(), true);
            if (added == 0) {
                if (this.START_INDEX == 0 && arrayLength - 1 <= this.END_INDEX) {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.all.elements.null", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                } else {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.all.array.elements.null", (Object[])new Object[]{this.START_INDEX, this.END_INDEX}), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                }
            } else {
                if (hiddenNulls) {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.elements.null.hidden", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                }
                if (!this.myForced && idx < end) {
                    builder.tooManyChildren(end - idx);
                }
            }
        }
    }

    private static boolean elementIsNull(ArrayReference arrayReference, int index) {
        try {
            return ArrayElementDescriptorImpl.getArrayElement(arrayReference, index) == null;
        }
        catch (EvaluateException e) {
            return false;
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl, (Object)node.getDescriptor().getClass().getName());
        ArrayElementDescriptorImpl descriptor2 = (ArrayElementDescriptorImpl)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)node.getProject()).getElementFactory();
        try {
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)node.getProject()).getLanguageLevel();
            return elementFactory.createExpressionFromText("this[" + descriptor2.getIndex() + "]", (PsiElement)elementFactory.getArrayClass(languageLevel));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isExpandable(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return value2 instanceof ArrayReference && ((ArrayReference)value2).length() > 0;
    }

    @Override
    public boolean isApplicable(Type type2) {
        return type2 instanceof ArrayType;
    }

    public static class Filtered
    extends ArrayRenderer {
        private final XExpression myExpression;
        public static final XDebuggerTreeNodeHyperlink FILTER_HYPERLINK = new XDebuggerTreeNodeHyperlink(" clear"){

            public void onClick(MouseEvent e) {
                TreeNode parent;
                XDebuggerTree tree = (XDebuggerTree)((Object)e.getSource());
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path != null && (parent = ((TreeNode)path.getLastPathComponent()).getParent()) instanceof XValueNodeImpl) {
                    XValueNodeImpl valueNode = (XValueNodeImpl)parent;
                    ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), valueNode, DebuggerManagerEx.getInstanceEx(tree.getProject()).getContext());
                }
                e.consume();
            }
        };

        public Filtered(XExpression expression2) {
            this.myExpression = expression2;
        }

        public XExpression getExpression() {
            return this.myExpression;
        }

        @Override
        public void buildChildren(Value value2, ChildrenBuilder builder, final EvaluationContext evaluationContext) {
            ArrayReference array;
            int arrayLength;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            NodeManagerImpl nodeManager = (NodeManagerImpl)builder.getNodeManager();
            NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
            builder.setMessage(DebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]) + " " + this.myExpression.getExpression(), AllIcons.General.Filter, SimpleTextAttributes.REGULAR_ATTRIBUTES, FILTER_HYPERLINK);
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            if ((arrayLength = (array = (ArrayReference)value2).length()) > 0) {
                builder.initChildrenArrayRenderer(this, arrayLength);
                CachedEvaluator cachedEvaluator = new CachedEvaluator(){

                    @Override
                    protected String getClassName() {
                        return ((ArrayType)array.type()).componentTypeName();
                    }

                    @Override
                    protected PsiElement overrideContext(PsiElement context) {
                        return ContextUtil.getContextElement((StackFrameContext)evaluationContext);
                    }
                };
                cachedEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(this.myExpression));
                int added = 0;
                if (arrayLength - 1 >= this.START_INDEX) {
                    ErrorsValueGroup errorsGroup = null;
                    for (int idx = this.START_INDEX; idx < arrayLength; ++idx) {
                        try {
                            if (!DebuggerUtilsEx.evaluateBoolean(cachedEvaluator.getEvaluator(evaluationContext.getProject()), (EvaluationContextImpl)evaluationContext.createEvaluationContext(array.getValue(idx)))) continue;
                            DebuggerTreeNodeImpl arrayItemNode = nodeManager.createNode(descriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), array, idx), evaluationContext);
                            builder.addChildren(Collections.singletonList(arrayItemNode), false);
                            ++added;
                            continue;
                        }
                        catch (EvaluateException e) {
                            if (errorsGroup == null) {
                                errorsGroup = new ErrorsValueGroup();
                                builder.addChildren(XValueChildrenList.bottomGroup((XValueGroup)errorsGroup), false);
                            }
                            JavaValue childValue = JavaValue.create(null, (ValueDescriptorImpl)((Object)descriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), array, idx)), (EvaluationContextImpl)evaluationContext, nodeManager, false);
                            errorsGroup.addErrorValue(e.getMessage(), childValue);
                        }
                    }
                }
                builder.addChildren(Collections.emptyList(), true);
            }
        }
    }
}

