/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Type;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFieldInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final UserExpressionDescriptorImpl myDescriptor;
    protected final EnumerationChildrenRenderer myRenderer;

    public CustomFieldInplaceEditor(@NotNull XDebuggerTreeNode node, @Nullable UserExpressionDescriptorImpl descriptor2, @Nullable EnumerationChildrenRenderer renderer) {
        if (node == null) {
            CustomFieldInplaceEditor.$$$reportNull$$$0(0);
        }
        super(node, "customField");
        this.myDescriptor = descriptor2;
        this.myRenderer = renderer;
        this.myExpressionEditor.setExpression(descriptor2 != null ? TextWithImportsImpl.toXExpression(descriptor2.getEvaluationText()) : null);
        ValueDescriptorImpl parentDescriptor = ((JavaValue)((XValueContainerNode)node.getParent()).getValueContainer()).getDescriptor();
        Pair<PsiElement, PsiType> pair2 = DebuggerUtilsImpl.getPsiClassAndType(CustomFieldInplaceEditor.getTypeName(parentDescriptor), this.getProject());
        if (pair2.first != null) {
            this.myExpressionEditor.setContext((PsiElement)pair2.first);
        }
    }

    public static void editNew(final @NotNull XValueNodeImpl parentNode) {
        if (parentNode == null) {
            CustomFieldInplaceEditor.$$$reportNull$$$0(1);
        }
        final ValueDescriptorImpl descriptor2 = ((JavaValue)parentNode.getValueContainer()).getDescriptor();
        EnumerationChildrenRenderer renderer = EnumerationChildrenRenderer.getCurrent(descriptor2);
        final XDebuggerTreeNode newNode = parentNode.addTemporaryEditorNode(AllIcons.Debugger.Watch, null);
        DebuggerUIUtil.invokeLater(() -> {
            if (parentNode == null) {
                CustomFieldInplaceEditor.$$$reportNull$$$0(2);
            }
            new CustomFieldInplaceEditor(newNode, null, renderer){

                @Override
                public void cancelEditing() {
                    super.cancelEditing();
                    parentNode.removeTemporaryEditorNode(newNode);
                }

                @Override
                protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
                    if (this.myRenderer != null) {
                        return this.myRenderer.getChildren();
                    }
                    String name2 = CustomFieldInplaceEditor.getTypeName(descriptor2);
                    EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
                    enumerationChildrenRenderer.setAppendDefaultChildren(true);
                    Renderer lastRenderer = descriptor2.getLastRenderer();
                    if (lastRenderer instanceof CompoundNodeRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)lastRenderer) && !(((CompoundNodeRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer)) {
                        ((CompoundNodeRenderer)lastRenderer).setChildrenRenderer(enumerationChildrenRenderer);
                    } else {
                        CompoundTypeRenderer renderer = NodeRendererSettings.getInstance().createCompoundTypeRenderer(name2, name2, null, enumerationChildrenRenderer);
                        renderer.setEnabled(true);
                        NodeRendererSettings.getInstance().getCustomRenderers().addRenderer(renderer);
                        NodeRendererSettings.getInstance().fireRenderersChanged();
                    }
                    return enumerationChildrenRenderer.getChildren();
                }
            }.show();
        });
    }

    @Nullable
    private static String getTypeName(ValueDescriptorImpl descriptor2) {
        Type type2 = descriptor2.getType();
        return type2 != null ? type2.name() : null;
    }

    protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
        return this.myRenderer.getChildren();
    }

    @Override
    public void doOKAction() {
        List<EnumerationChildrenRenderer.ChildInfo> children2 = this.getRendererChildren();
        TextWithImports newText = TextWithImportsImpl.fromXExpression(this.myExpressionEditor.getExpression());
        if (this.myDescriptor == null) {
            children2.add(0, new EnumerationChildrenRenderer.ChildInfo("", newText, false));
        } else {
            int index = this.myDescriptor.getEnumerationIndex();
            EnumerationChildrenRenderer.ChildInfo old = children2.get(index);
            children2.set(index, new EnumerationChildrenRenderer.ChildInfo(old.myName, newText, old.myOnDemand));
        }
        this.myTree.putClientProperty("selection.path", CustomFieldInplaceEditor.createDummySelectionTreePath(newText.getText(), (XDebuggerTreeNode)this.myNode.getParent()));
        XDebuggerUtilImpl.rebuildTreeAndViews(this.myTree);
        super.doOKAction();
    }

    private static TreePath createDummySelectionTreePath(String name2, XDebuggerTreeNode parentNode) {
        return new XValueNodeImpl(parentNode.getTree(), parentNode, name2, new XValue(){

            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor$2";
                objectArray[2] = "computePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).getPath();
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds = super.getEditorBounds();
        if (bounds == null) {
            return null;
        }
        int afterIconX = this.getAfterIconX();
        bounds.x += afterIconX;
        bounds.width -= afterIconX;
        return bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "editNew";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$editNew$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

