/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.designSurface.AbstractEditOperation;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.util.ArrayUtil;
import java.awt.Point;
import org.jetbrains.annotations.Nullable;

public abstract class TreeEditOperation
extends AbstractEditOperation {
    protected RadComponent myTarget;
    protected boolean myInsertBefore;

    public TreeEditOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    public static boolean isTarget(RadComponent container, OperationContext context) {
        Point location = context.getLocation();
        RadComponent target2 = context.getArea().findTarget(location.x, location.y, null);
        if (target2 == container) {
            FeedbackTreeLayer layer = context.getArea().getFeedbackTreeLayer();
            return !layer.isBeforeLocation(target2, location.x, location.y) && !layer.isAfterLocation(target2, location.x, location.y);
        }
        return true;
    }

    protected Object[] getChildren() {
        return this.myContainer.getTreeChildren();
    }

    @Override
    public void showFeedback() {
        Point location = this.myContext.getLocation();
        FeedbackTreeLayer layer = this.myContext.getArea().getFeedbackTreeLayer();
        this.myTarget = this.myContext.getArea().findTarget(location.x, location.y, null);
        if (this.myContainer == this.myTarget) {
            layer.mark(this.myTarget, 2);
        } else if (this.myTarget != null && this.isChildren(this.myTarget)) {
            this.myInsertBefore = layer.isBeforeLocation(this.myTarget, location.x, location.y);
            layer.mark(this.myTarget, this.myInsertBefore ? 0 : 1);
        } else {
            this.myTarget = null;
            this.eraseFeedback();
        }
    }

    protected final boolean isChildren(RadComponent component) {
        return ArrayUtil.indexOf((Object[])this.getChildren(), (Object)component) != -1;
    }

    @Override
    public void eraseFeedback() {
        this.myContext.getArea().getFeedbackTreeLayer().unmark();
    }

    @Override
    public boolean canExecute() {
        if (this.myTarget == null) {
            return false;
        }
        if (this.myContext.isMove() && this.myTarget != this.myContainer) {
            if (this.myComponents.contains(this.myTarget)) {
                return false;
            }
            Object[] children2 = this.getChildren();
            int index = ArrayUtil.indexOf((Object[])children2, (Object)this.myTarget) + (this.myInsertBefore ? -1 : 1);
            if (0 <= index && index < children2.length) {
                return !this.myComponents.contains(children2[index]);
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        if (this.myTarget == this.myContainer) {
            this.execute(null);
        } else if (this.myInsertBefore) {
            this.execute(this.myTarget);
        } else {
            Object[] children2 = this.getChildren();
            int index = ArrayUtil.indexOf((Object[])children2, (Object)this.myTarget) + 1;
            if (index < children2.length) {
                this.execute((RadComponent)children2[index]);
            } else {
                this.execute(null);
            }
        }
    }

    protected abstract void execute(@Nullable RadComponent var1) throws Exception;
}

