/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.jetbrains.annotations.NotNull;

public final class ColorIcon
extends EmptyIcon {
    private final int myColorSize;
    private Color myColor;
    private boolean myShowRedLine;

    public ColorIcon(int size, int colorSize) {
        super(size, size);
        this.myColorSize = colorSize;
    }

    protected ColorIcon(ColorIcon icon) {
        super((EmptyIcon)icon);
        this.myColorSize = icon.myColorSize;
        this.myColor = icon.myColor;
        this.myShowRedLine = icon.myShowRedLine;
    }

    @NotNull
    protected ColorIcon copy() {
        ColorIcon colorIcon = new ColorIcon(this);
        if (colorIcon == null) {
            ColorIcon.$$$reportNull$$$0(0);
        }
        return colorIcon;
    }

    public Color getColor() {
        return this.myShowRedLine ? null : this.myColor;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void showRedLine(boolean value2) {
        this.myShowRedLine = value2;
    }

    public void paintIcon(Component component, Graphics g, int left, int top) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        if (component instanceof SimpleColoredComponent) {
            SimpleColoredComponent coloredComponent = (SimpleColoredComponent)component;
            g.setColor(component.getBackground());
            g.fillRect(left - coloredComponent.getIpad().left, 0, iconWidth + coloredComponent.getIpad().left + coloredComponent.getIconTextGap(), component.getHeight());
        }
        int x = left + (int)Math.floor(((double)iconWidth - this.scaleVal(this.myColorSize)) / 2.0);
        int y = top + (int)Math.floor(((double)iconHeight - this.scaleVal(this.myColorSize)) / 2.0);
        g.setColor(this.myColor);
        g.fillRect(x, y, (int)Math.ceil(this.scaleVal(this.myColorSize)), (int)Math.ceil(this.scaleVal(this.myColorSize)));
        if (this.myShowRedLine) {
            Graphics2D g2d = (Graphics2D)g;
            Object hint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor((Color)JBColor.red);
            g.drawLine(x, y + (int)Math.floor(this.scaleVal(this.myColorSize)), x + (int)Math.floor(this.scaleVal(this.myColorSize)), y);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, (int)Math.ceil(this.scaleVal(this.myColorSize)), (int)Math.ceil(this.scaleVal(this.myColorSize)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/renderers/ColorIcon", "copy"));
    }
}

