/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdeFatalErrorsIcon;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMessagePanel
extends JPanel
implements MessagePoolListener,
IconLikeCustomStatusBarWidget {
    public static final String FATAL_ERROR = "FatalError";
    private final IdeFatalErrorsIcon myIdeFatal;
    private Balloon myBalloon;
    static final String INTERNAL_ERROR_NOTICE = DiagnosticBundle.message("error.notification.tooltip", new Object[0]);
    private IdeErrorsDialog myDialog;
    private boolean myOpeningInProgress;
    private final IdeFrame myFrame;
    private final MessagePool myMessagePool;
    private boolean myNotificationPopupAlreadyShown;
    private static final String ERROR_TITLE = DiagnosticBundle.message("error.new.notification.title", new Object[0]);
    private static final String ERROR_LINK = DiagnosticBundle.message("error.new.notification.link", new Object[0]);

    public IdeMessagePanel(@Nullable IdeFrame frame, @NotNull MessagePool messagePool) {
        if (messagePool == null) {
            IdeMessagePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myNotificationPopupAlreadyShown = false;
        this.myIdeFatal = new IdeFatalErrorsIcon(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeMessagePanel.this.openFatals(null);
            }
        }, frame != null);
        this.myIdeFatal.setVerticalAlignment(0);
        this.add((Component)this.myIdeFatal, "Center");
        this.myFrame = frame;
        this.myMessagePool = messagePool;
        messagePool.addListener(this);
        this.updateFatalErrorsIcon();
        this.setOpaque(false);
    }

    @NotNull
    public String ID() {
        if (FATAL_ERROR == null) {
            IdeMessagePanel.$$$reportNull$$$0(1);
        }
        return FATAL_ERROR;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
        if (type2 == null) {
            IdeMessagePanel.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void dispose() {
        this.myMessagePool.removeListener(this);
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeMessagePanel.$$$reportNull$$$0(3);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void openFatals(final @Nullable LogMessage message2) {
        if (this.myDialog != null) {
            return;
        }
        if (this.myOpeningInProgress) {
            return;
        }
        this.myOpeningInProgress = true;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (IdeMessagePanel.this.isOtherModalWindowActive()) {
                    if (IdeMessagePanel.this.myDialog == null) {
                        EdtExecutorService.getScheduledExecutorInstance().schedule(this, 300L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                try {
                    IdeMessagePanel.this._openFatals(message2);
                }
                finally {
                    IdeMessagePanel.this.myOpeningInProgress = false;
                }
            }
        };
        task.run();
    }

    private void _openFatals(@Nullable LogMessage message2) {
        this.myDialog = new IdeErrorsDialog(this.myMessagePool, message2){

            @Override
            public void doOKAction() {
                super.doOKAction();
                IdeMessagePanel.this.disposeDialog(this);
            }

            @Override
            public void doCancelAction() {
                super.doCancelAction();
                IdeMessagePanel.this.disposeDialog(this);
            }

            @Override
            protected void updateOnSubmit() {
                super.updateOnSubmit();
                IdeMessagePanel.this.updateState(IdeMessagePanel.this.computeState());
            }
        };
        this.myMessagePool.addListener(this.myDialog);
        if (!this.isOtherModalWindowActive()) {
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            this.myDialog.show();
        } else {
            this.myDialog.close(0);
            this.disposeDialog(this.myDialog);
        }
    }

    private void updateState(IdeFatalErrorsIcon.State state) {
        this.myIdeFatal.setState(state);
        UIUtil.invokeLaterIfNeeded(() -> this.setVisible(state != IdeFatalErrorsIcon.State.NoErrors));
    }

    private void disposeDialog(IdeErrorsDialog listDialog) {
        this.myMessagePool.removeListener(listDialog);
        this.updateFatalErrorsIcon();
        this.myDialog = null;
    }

    @Override
    public void newEntryAdded() {
        this.updateFatalErrorsIcon();
    }

    @Override
    public void poolCleared() {
        this.updateFatalErrorsIcon();
    }

    @Override
    public void entryWasRead() {
        this.updateFatalErrorsIcon();
    }

    private boolean isOtherModalWindowActive() {
        Window window = IdeMessagePanel.getActiveModalWindow();
        if (window == null) {
            return false;
        }
        return this.myDialog == null || this.myDialog.getWindow() != window;
    }

    private static Window getActiveModalWindow() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal()) {
            return activeWindow;
        }
        return null;
    }

    private IdeFatalErrorsIcon.State computeState() {
        List<AbstractMessage> errors = this.myMessagePool.getFatalErrors(true, false);
        if (errors.isEmpty()) {
            return IdeFatalErrorsIcon.State.NoErrors;
        }
        for (AbstractMessage error : errors) {
            if (error.isRead()) continue;
            return IdeFatalErrorsIcon.State.UnreadErrors;
        }
        return IdeFatalErrorsIcon.State.ReadErrors;
    }

    void updateFatalErrorsIcon() {
        IdeFatalErrorsIcon.State state = this.computeState();
        this.updateState(state);
        if (state == IdeFatalErrorsIcon.State.NoErrors) {
            this.myNotificationPopupAlreadyShown = false;
        } else if (state == IdeFatalErrorsIcon.State.UnreadErrors && !this.myNotificationPopupAlreadyShown) {
            Project project2;
            Project project3 = project2 = this.myFrame == null ? null : this.myFrame.getProject();
            if (project2 != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    String notificationText = IdeMessagePanel.tryGetFromMessages(this.myMessagePool.getFatalErrors(false, false));
                    this.showErrorNotification(notificationText, project2);
                }, project2.getDisposed());
                this.myNotificationPopupAlreadyShown = true;
            }
        }
    }

    private void showErrorNotification(@Nullable String notificationText, @NotNull Project project2) {
        if (project2 == null) {
            IdeMessagePanel.$$$reportNull$$$0(4);
        }
        Notification notification = new Notification("", AllIcons.Ide.FatalError, notificationText == null ? ERROR_TITLE : "", null, notificationText == null ? "" : notificationText, NotificationType.ERROR, null);
        if (notificationText == null) {
            notification.addAction((AnAction)new NotificationAction(ERROR_LINK){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    IdeMessagePanel.this._openFatals(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/IdeMessagePanel$4";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        BalloonLayout layout = this.myFrame.getBalloonLayout();
        assert (layout != null);
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = 5000L;
        layoutData.fillColor = new JBColor(16115431, 5848385);
        layoutData.borderColor = new JBColor(14723241, 7554379);
        assert (this.myBalloon == null);
        this.myBalloon = NotificationsManagerImpl.createBalloon(this.myFrame, notification, false, false, (Ref<BalloonLayoutData>)new Ref((Object)layoutData), (Disposable)project2);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.myBalloon = null;
        });
        layout.add(this.myBalloon);
    }

    private static String tryGetFromMessages(List<AbstractMessage> messages) {
        String result2 = null;
        for (AbstractMessage message2 : messages) {
            String s;
            if (message2 instanceof LogMessageEx) {
                s = ((LogMessageEx)message2).getNotificationText();
            } else if (message2 instanceof GroupedLogMessage) {
                s = IdeMessagePanel.tryGetFromMessages(((GroupedLogMessage)message2).getMessages());
            } else {
                return null;
            }
            if (result2 == null) {
                result2 = s;
                continue;
            }
            if (result2.equals(s)) continue;
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeMessagePanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeMessagePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

