/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class OutOfMemoryDialog
extends DialogWrapper {
    private final VMOptions.MemoryKind myMemoryKind;
    private JPanel myContentPane;
    private JBLabel myIconLabel;
    private JBLabel myMessageLabel;
    private JBLabel myHeapSizeLabel;
    private JTextField myHeapSizeField;
    private JBLabel myHeapUnitsLabel;
    private JBLabel myHeapCurrentValueLabel;
    private JBLabel myMetaspaceSizeLabel;
    private JTextField myMetaspaceSizeField;
    private JBLabel myMetaspaceUnitsLabel;
    private JBLabel myMetaspaceCurrentValueLabel;
    private JBLabel myCodeCacheSizeLabel;
    private JTextField myCodeCacheSizeField;
    private JBLabel myCodeCacheUnitsLabel;
    private JBLabel myCodeCacheCurrentValueLabel;
    private JBLabel mySettingsFileHintLabel;
    private JBLabel myDumpMessageLabel;
    private final Action myContinueAction;
    private final Action myShutdownAction;
    private final Action myHeapDumpAction;

    public OutOfMemoryDialog(@NotNull VMOptions.MemoryKind memoryKind) {
        if (memoryKind == null) {
            OutOfMemoryDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.myMemoryKind = memoryKind;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("diagnostic.out.of.memory.title", objectArray));
        this.myIconLabel.setIcon(Messages.getErrorIcon());
        this.myMessageLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.error", memoryKind.optionName));
        this.myMessageLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        File file2 = VMOptions.getWriteFile();
        if (file2 != null) {
            this.mySettingsFileHintLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.willBeSavedTo", file2.getPath()));
            this.mySettingsFileHintLabel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        } else {
            this.mySettingsFileHintLabel.setVisible(false);
            this.myHeapSizeField.setEnabled(false);
            this.myMetaspaceSizeField.setEnabled(false);
            this.myCodeCacheSizeField.setEnabled(false);
        }
        this.myContinueAction = new DialogWrapper.DialogWrapperAction(DiagnosticBundle.message("diagnostic.out.of.memory.continue", new Object[0])){

            protected void doAction(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                OutOfMemoryDialog.this.close(0);
            }
        };
        this.myShutdownAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"ide.shutdown.action", (Object[])new Object[0])){

            protected void doAction(ActionEvent e) {
                OutOfMemoryDialog.this.save();
                System.exit(9);
            }
        };
        this.myShutdownAction.putValue("DefaultAction", true);
        boolean heapDump = memoryKind == VMOptions.MemoryKind.HEAP && MemoryDumpHelper.memoryDumpAvailable();
        this.myHeapDumpAction = !heapDump ? null : new DialogWrapper.DialogWrapperAction(DiagnosticBundle.message("diagnostic.out.of.memory.dump", new Object[0])){

            protected void doAction(ActionEvent e) {
                OutOfMemoryDialog.this.snapshot();
            }
        };
        this.configControls(VMOptions.MemoryKind.HEAP, (JLabel)this.myHeapSizeLabel, this.myHeapSizeField, (JLabel)this.myHeapUnitsLabel, (JLabel)this.myHeapCurrentValueLabel);
        this.configControls(VMOptions.MemoryKind.METASPACE, (JLabel)this.myMetaspaceSizeLabel, this.myMetaspaceSizeField, (JLabel)this.myMetaspaceUnitsLabel, (JLabel)this.myMetaspaceCurrentValueLabel);
        this.configControls(VMOptions.MemoryKind.CODE_CACHE, (JLabel)this.myCodeCacheSizeLabel, this.myCodeCacheSizeField, (JLabel)this.myCodeCacheUnitsLabel, (JLabel)this.myCodeCacheCurrentValueLabel);
        this.init();
    }

    private void configControls(VMOptions.MemoryKind option, JLabel sizeLabel, JTextField sizeField, JLabel unitsLabel, JLabel currentLabel) {
        sizeLabel.setText('-' + option.optionName);
        int effective = VMOptions.readOption(option, true);
        int stored = VMOptions.readOption(option, false);
        if (stored == -1) {
            stored = effective;
        }
        sizeField.setText(OutOfMemoryDialog.format(stored));
        currentLabel.setText(DiagnosticBundle.message("diagnostic.out.of.memory.currentValue", OutOfMemoryDialog.format(effective)));
        if (option == this.myMemoryKind) {
            sizeLabel.setForeground((Color)JBColor.RED);
            sizeField.setForeground((Color)JBColor.RED);
            unitsLabel.setForeground((Color)JBColor.RED);
            currentLabel.setForeground((Color)JBColor.RED);
        }
    }

    private static String format(int value2) {
        return value2 == -1 ? DiagnosticBundle.message("diagnostic.out.of.memory.currentValue.unknown", new Object[0]) : String.valueOf(value2);
    }

    private void save() {
        try {
            int heapSize = Integer.parseInt(this.myHeapSizeField.getText());
            VMOptions.writeOption(VMOptions.MemoryKind.HEAP, heapSize);
        }
        catch (NumberFormatException heapSize) {
            // empty catch block
        }
        try {
            int codeCacheSize = Integer.parseInt(this.myMetaspaceSizeField.getText());
            VMOptions.writeOption(VMOptions.MemoryKind.METASPACE, codeCacheSize);
        }
        catch (NumberFormatException codeCacheSize) {
            // empty catch block
        }
        try {
            int codeCacheSize = Integer.parseInt(this.myCodeCacheSizeField.getText());
            VMOptions.writeOption(VMOptions.MemoryKind.CODE_CACHE, codeCacheSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void snapshot() {
        this.enableControls(false);
        this.myDumpMessageLabel.setVisible(true);
        this.myDumpMessageLabel.setText("Dumping memory...");
        Runnable task = () -> {
            TimeoutUtil.sleep((long)250L);
            String message2 = "";
            try {
                String name2 = ApplicationNamesInfo.getInstance().getFullProductName().replace(' ', '-').toLowerCase(Locale.US);
                String path = SystemProperties.getUserHome() + File.separator + "heapDump-" + name2 + '-' + System.currentTimeMillis() + ".hprof.zip";
                MemoryDumpHelper.captureMemoryDumpZipped((String)path);
                message2 = "Dumped to " + path;
            }
            catch (Throwable t) {
                message2 = "Error: " + t.getMessage();
            }
            finally {
                String _message = message2;
                SwingUtilities.invokeLater(() -> {
                    this.myDumpMessageLabel.setText(_message);
                    this.enableControls(true);
                });
            }
        };
        new Thread(task, "OOME Heap Dump").start();
    }

    private void enableControls(boolean enabled) {
        this.myHeapSizeField.setEnabled(enabled);
        this.myMetaspaceSizeField.setEnabled(enabled);
        this.myCodeCacheSizeField.setEnabled(enabled);
        this.myShutdownAction.setEnabled(enabled);
        this.myContinueAction.setEnabled(enabled);
        this.myHeapDumpAction.setEnabled(enabled);
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        if (this.myHeapDumpAction != null) {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.myShutdownAction;
            actionArray2[1] = this.myContinueAction;
            actionArray = actionArray2;
            actionArray2[2] = this.myHeapDumpAction;
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = this.myShutdownAction;
            actionArray = actionArray3;
            actionArray3[1] = this.myContinueAction;
        }
        if (actionArray == null) {
            OutOfMemoryDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemoryKind == VMOptions.MemoryKind.METASPACE ? this.myMetaspaceSizeField : (this.myMemoryKind == VMOptions.MemoryKind.CODE_CACHE ? this.myCodeCacheSizeField : this.myHeapSizeField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/OutOfMemoryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/OutOfMemoryDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JTextField jTextField;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JTextField jTextField2;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JBLabel jBLabel10;
        JTextField jTextField3;
        JBLabel jBLabel11;
        JBLabel jBLabel12;
        JBLabel jBLabel13;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIconLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("");
        jPanel.add((Component)jBLabel13, new GridConstraints(0, 0, 7, 1, 1, 0, 0, 0, null, null, null));
        this.myMessageLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Label");
        jPanel.add((Component)jBLabel12, new GridConstraints(0, 1, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Label");
        jPanel.add((Component)jBLabel11, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHeapSizeField = jTextField3 = new JTextField();
        jTextField3.setColumns(6);
        jPanel.add((Component)jTextField3, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myHeapUnitsLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("MB");
        jPanel.add((Component)jBLabel10, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapCurrentValueLabel = jBLabel9 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 2, -1, jBLabel9.getFont());
        if (font != null) {
            jBLabel9.setFont(font);
        }
        jBLabel9.setText("Label");
        jPanel.add((Component)jBLabel9, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMetaspaceSizeLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Label");
        jPanel.add((Component)jBLabel8, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        this.myMetaspaceSizeField = jTextField2 = new JTextField();
        jTextField2.setColumns(6);
        jPanel.add((Component)jTextField2, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myMetaspaceUnitsLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("MB");
        jPanel.add((Component)jBLabel7, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMetaspaceCurrentValueLabel = jBLabel6 = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, 2, -1, jBLabel6.getFont());
        if (font2 != null) {
            jBLabel6.setFont(font2);
        }
        jBLabel6.setText("Label");
        jPanel.add((Component)jBLabel6, new GridConstraints(2, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeCacheSizeLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Label");
        jPanel.add((Component)jBLabel5, new GridConstraints(3, 1, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        this.myCodeCacheSizeField = jTextField = new JTextField();
        jTextField.setColumns(6);
        jPanel.add((Component)jTextField, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCodeCacheUnitsLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("MB");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeCacheCurrentValueLabel = jBLabel3 = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, 2, -1, jBLabel3.getFont());
        if (font3 != null) {
            jBLabel3.setFont(font3);
        }
        jBLabel3.setText("Label");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 5, 3, 1, 0, 1, 6, 1, null, null, null));
        this.mySettingsFileHintLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Label");
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 1, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myDumpMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(5, 1, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 1, 1, 5, 0, 2, 1, 6, null, new Dimension(51, 14), null));
        jBLabel11.setLabelFor(jTextField3);
        jBLabel8.setLabelFor(jTextField2);
        jBLabel5.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

