/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final List<? extends Editor> myEditors;
    @Nullable
    private SyncScrollSupport.Support mySyncScrollSupport;
    @NotNull
    private final AnAction[] myActions;

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors) {
        if (settings == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(1);
        }
        super("Editor Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myEditors = editors;
        for (Editor editor : this.myEditors) {
            ((EditorGutterComponentEx)editor.getGutter()).setGutterPopupGroup(this);
        }
        this.myActions = new AnAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhitespaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value2) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isWhitespacesShown() != value2) {
                    editor.getSettings().setWhitespacesShown(value2);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$1", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value2) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isLineNumbersShown() != value2) {
                    editor.getSettings().setLineNumbersShown(value2);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$2", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value2) {
                if (editor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isIndentGuidesShown() != value2) {
                    editor.getSettings().setIndentGuidesShown(value2);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$3", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                return this.myForcedSoftWrap || SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value2) {
                if (editor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isUseSoftWraps() == value2) {
                    return;
                }
                if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                    SetEditorSettingsAction.this.mySyncScrollSupport.enterDisableScrollSection();
                }
                try {
                    AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, null, value2);
                }
                finally {
                    if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                        SetEditorSettingsAction.this.mySyncScrollSupport.exitDisableScrollSection();
                    }
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors) {
                if (editors == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps()) {
                    for (Editor editor : editors) {
                        this.myForcedSoftWrap = this.myForcedSoftWrap || ((EditorImpl)editor).shouldSoftWrapsBeForced();
                    }
                }
                super.applyDefaults(editors);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editors";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyDefaults";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new EditorHighlightingLayerAction()};
    }

    public void setSyncScrollSupport(@Nullable SyncScrollSupport.Support syncScrollSupport) {
        this.mySyncScrollSupport = syncScrollSupport;
    }

    public void applyDefaults() {
        for (AnAction action : this.myActions) {
            ((EditorSettingAction)action).applyDefaults(this.myEditors);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Object[] children2 = ((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu")).getChildren(e);
        AnAction editorSettingsGroup = ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu.EditorSettings");
        DefaultActionGroup ourGroup = new DefaultActionGroup();
        ourGroup.add((AnAction)Separator.getInstance());
        ourGroup.addAll(this.myActions);
        ourGroup.add(editorSettingsGroup);
        ourGroup.add((AnAction)Separator.getInstance());
        ArrayList result2 = ContainerUtil.newArrayList((Object[])children2);
        SetEditorSettingsAction.replaceOrAppend(result2, editorSettingsGroup, ourGroup);
        AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)result2, AnAction.class);
        if (anActionArray == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static <T> void replaceOrAppend(List<T> list2, T from, T to) {
        int index = list2.indexOf(from);
        if (index == -1) {
            index = list2.size();
        }
        list2.remove(from);
        list2.add(index, to);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface EditorSettingAction {
        public void applyDefaults(@NotNull List<? extends Editor> var1);
    }

    private class EditorHighlightingLayerAction
    extends ActionGroup
    implements EditorSettingAction {
        private final AnAction[] myOptions;

        public EditorHighlightingLayerAction() {
            super("Highlighting Level", true);
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])HighlightingLevel.values(), level -> new OptionAction((HighlightingLevel)((Object)level)), (Object[])AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                EditorHighlightingLayerAction.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                EditorHighlightingLayerAction.$$$reportNull$$$0(1);
            }
            this.apply(SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel());
        }

        private void apply(@NotNull HighlightingLevel layer) {
            if (layer == null) {
                EditorHighlightingLayerAction.$$$reportNull$$$0(2);
            }
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                ((EditorImpl)editor).setHighlightingFilter(layer.getCondition());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final HighlightingLevel myLayer;

            public OptionAction(HighlightingLevel layer) {
                if (layer == null) {
                    OptionAction.$$$reportNull$$$0(0);
                }
                super(layer.getText(), null, layer.getIcon());
                this.myLayer = layer;
            }

            public boolean isSelected(AnActionEvent e) {
                return SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel() == this.myLayer;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setHighlightingLevel(this.myLayer);
                EditorHighlightingLayerAction.this.apply(this.myLayer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerAction$OptionAction", "<init>"));
            }
        }
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware,
    EditorSettingAction {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(0);
            }
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
            this.getTemplatePresentation().setIcon(null);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.setSelected(state);
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(1);
            }
            for (Editor editor : editors) {
                this.apply(editor, this.isSelected());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyDefaults";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

