/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LineFragmentSplitter {
    @NotNull
    private final CharSequence myText1;
    @NotNull
    private final CharSequence myText2;
    @NotNull
    private final List<ByWord.InlineChunk> myWords1;
    @NotNull
    private final List<ByWord.InlineChunk> myWords2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final List<WordBlock> myResult;
    private int last1;
    private int last2;
    private PendingChunk pendingChunk;

    public LineFragmentSplitter(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<ByWord.InlineChunk> words1, @NotNull List<ByWord.InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(1);
        }
        if (words1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(2);
        }
        if (words2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(3);
        }
        if (iterable == null) {
            LineFragmentSplitter.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            LineFragmentSplitter.$$$reportNull$$$0(5);
        }
        this.myResult = new ArrayList<WordBlock>();
        this.last1 = -1;
        this.last2 = -1;
        this.pendingChunk = null;
        this.myText1 = text1;
        this.myText2 = text2;
        this.myWords1 = words1;
        this.myWords2 = words2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
    }

    @NotNull
    public List<WordBlock> run() {
        boolean hasEqualWords = false;
        for (Range range : this.myIterable.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = range.start1 + i;
                int index2 = range.start2 + i;
                if (LineFragmentSplitter.isNewline(this.myWords1, index1) && LineFragmentSplitter.isNewline(this.myWords2, index2)) {
                    this.addLineChunk(index1, index2, hasEqualWords);
                    hasEqualWords = false;
                    continue;
                }
                if (LineFragmentSplitter.isFirstInLine(this.myWords1, index1) && LineFragmentSplitter.isFirstInLine(this.myWords2, index2)) {
                    this.addLineChunk(index1 - 1, index2 - 1, hasEqualWords);
                    hasEqualWords = false;
                }
                hasEqualWords = true;
            }
        }
        this.addLineChunk(this.myWords1.size(), this.myWords2.size(), hasEqualWords);
        if (this.pendingChunk != null) {
            this.myResult.add(this.pendingChunk.block);
        }
        List<WordBlock> list2 = this.myResult;
        if (list2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private void addLineChunk(int end1, int end2, boolean hasEqualWords) {
        if (this.last1 > end1 || this.last2 > end2) {
            return;
        }
        PendingChunk chunk = this.createChunk(this.last1, this.last2, end1, end2, hasEqualWords);
        if (chunk.block.offsets.isEmpty()) {
            return;
        }
        if (this.pendingChunk != null && LineFragmentSplitter.shouldMergeChunks(this.pendingChunk, chunk)) {
            this.pendingChunk = LineFragmentSplitter.mergeChunks(this.pendingChunk, chunk);
        } else {
            if (this.pendingChunk != null) {
                this.myResult.add(this.pendingChunk.block);
            }
            this.pendingChunk = chunk;
        }
        this.last1 = end1;
        this.last2 = end2;
    }

    @NotNull
    private PendingChunk createChunk(int start1, int start2, int end1, int end2, boolean hasEqualWords) {
        int startOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, start1);
        int startOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, start2);
        int endOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, end1);
        int endOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, end2);
        start1 = Math.max(0, start1 + 1);
        start2 = Math.max(0, start2 + 1);
        end1 = Math.min(end1 + 1, this.myWords1.size());
        end2 = Math.min(end2 + 1, this.myWords2.size());
        WordBlock block = new WordBlock(new Range(start1, end1, start2, end2), new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        PendingChunk pendingChunk = new PendingChunk(block, hasEqualWords, this.hasWordsInside(block), this.isEqualsIgnoreWhitespace(block));
        if (pendingChunk == null) {
            LineFragmentSplitter.$$$reportNull$$$0(7);
        }
        return pendingChunk;
    }

    private static boolean shouldMergeChunks(@NotNull PendingChunk chunk1, @NotNull PendingChunk chunk2) {
        if (chunk1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(8);
        }
        if (chunk2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(9);
        }
        if (!chunk1.hasEqualWords && !chunk2.hasEqualWords) {
            return true;
        }
        if (chunk1.isEqualIgnoreWhitespaces && chunk2.isEqualIgnoreWhitespaces) {
            return true;
        }
        return !chunk1.hasWordsInside || !chunk2.hasWordsInside;
    }

    @NotNull
    private static PendingChunk mergeChunks(@NotNull PendingChunk chunk1, @NotNull PendingChunk chunk2) {
        if (chunk1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(10);
        }
        if (chunk2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(11);
        }
        WordBlock block1 = chunk1.block;
        WordBlock block2 = chunk2.block;
        WordBlock newBlock = new WordBlock(new Range(block1.words.start1, block2.words.end1, block1.words.start2, block2.words.end2), new Range(block1.offsets.start1, block2.offsets.end1, block1.offsets.start2, block2.offsets.end2));
        PendingChunk pendingChunk = new PendingChunk(newBlock, chunk1.hasEqualWords || chunk2.hasEqualWords, chunk1.hasWordsInside || chunk2.hasWordsInside, chunk1.isEqualIgnoreWhitespaces && chunk2.isEqualIgnoreWhitespaces);
        if (pendingChunk == null) {
            LineFragmentSplitter.$$$reportNull$$$0(12);
        }
        return pendingChunk;
    }

    private boolean isEqualsIgnoreWhitespace(@NotNull WordBlock block) {
        if (block == null) {
            LineFragmentSplitter.$$$reportNull$$$0(13);
        }
        CharSequence sequence1 = this.myText1.subSequence(block.offsets.start1, block.offsets.end1);
        CharSequence sequence2 = this.myText2.subSequence(block.offsets.start2, block.offsets.end2);
        return StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2);
    }

    private boolean hasWordsInside(@NotNull WordBlock block) {
        int i;
        if (block == null) {
            LineFragmentSplitter.$$$reportNull$$$0(14);
        }
        for (i = block.words.start1; i < block.words.end1; ++i) {
            if (this.myWords1.get(i) instanceof ByWord.NewlineChunk) continue;
            return true;
        }
        for (i = block.words.start2; i < block.words.end2; ++i) {
            if (this.myWords2.get(i) instanceof ByWord.NewlineChunk) continue;
            return true;
        }
        return false;
    }

    private static int getOffset(@NotNull List<ByWord.InlineChunk> words, @NotNull CharSequence text2, int index) {
        if (words == null) {
            LineFragmentSplitter.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(16);
        }
        if (index == -1) {
            return 0;
        }
        if (index == words.size()) {
            return text2.length();
        }
        ByWord.InlineChunk chunk = words.get(index);
        assert (chunk instanceof ByWord.NewlineChunk);
        return chunk.getOffset2();
    }

    private static boolean isNewline(@NotNull List<ByWord.InlineChunk> words1, int index) {
        if (words1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(17);
        }
        return words1.get(index) instanceof ByWord.NewlineChunk;
    }

    private static boolean isFirstInLine(@NotNull List<ByWord.InlineChunk> words1, int index) {
        if (words1 == null) {
            LineFragmentSplitter.$$$reportNull$$$0(18);
        }
        if (index == 0) {
            return true;
        }
        return words1.get(index - 1) instanceof ByWord.NewlineChunk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/LineFragmentSplitter";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk1";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk2";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/LineFragmentSplitter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChunk";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldMergeChunks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeChunks";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEqualsIgnoreWhitespace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasWordsInside";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNewline";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isFirstInLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PendingChunk {
        @NotNull
        public final WordBlock block;
        public final boolean hasEqualWords;
        public final boolean hasWordsInside;
        public final boolean isEqualIgnoreWhitespaces;

        public PendingChunk(@NotNull WordBlock block, boolean hasEqualWords, boolean hasWordsInside, boolean isEqualIgnoreWhitespaces) {
            if (block == null) {
                PendingChunk.$$$reportNull$$$0(0);
            }
            this.block = block;
            this.hasEqualWords = hasEqualWords;
            this.hasWordsInside = hasWordsInside;
            this.isEqualIgnoreWhitespaces = isEqualIgnoreWhitespaces;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/comparison/LineFragmentSplitter$PendingChunk", "<init>"));
        }
    }

    public static class WordBlock {
        @NotNull
        public final Range words;
        @NotNull
        public final Range offsets;

        public WordBlock(@NotNull Range words, @NotNull Range offsets) {
            if (words == null) {
                WordBlock.$$$reportNull$$$0(0);
            }
            if (offsets == null) {
                WordBlock.$$$reportNull$$$0(1);
            }
            this.words = words;
            this.offsets = offsets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "words";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/LineFragmentSplitter$WordBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

