/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        this(project2, file2, file2);
    }

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        assert (file2.isValid() && !file2.isDirectory());
        this.myFile = file2;
        this.myProject = project2;
        this.myType = file2.getFileType();
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.myHighlightFile)) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myType;
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        return fileType;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/FileContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/FileContentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

