/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(0);
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            return !(file2 instanceof VirtualFileWithoutContent);
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(2);
        }
        if (content instanceof EmptyContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(3);
            }
            return tempInputFile;
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file2);
                if (localInputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(4);
                }
                return localInputFile;
            }
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(5);
            }
            return tempInputFile;
        }
        if (content instanceof DocumentContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName));
            if (tempInputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(6);
            }
            return tempInputFile;
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content).getFile();
            if (file3.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file3);
                if (localInputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(7);
                }
                return localInputFile;
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(@NotNull DocumentContent content, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        Boolean hasBom;
        Charset charset;
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(9);
        }
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        if ((charset = content.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        if ((hasBom = content.hasBom()) == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = (String)ReadAction.compute(() -> {
            if (content == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(31);
            }
            return content.getDocument().getText();
        });
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        File file2 = ExternalDiffToolUtil.createFile(bytes, fileName);
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(10);
        }
        return file2;
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName) throws IOException {
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(12);
        }
        byte[] bytes = file2.contentsToByteArray();
        File file3 = ExternalDiffToolUtil.createFile(bytes, fileName);
        if (file3 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(13);
        }
        return file3;
    }

    @NotNull
    private static OutputFile createOutputFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(14);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(15);
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalOutputFile localOutputFile = new LocalOutputFile(file2);
                if (localOutputFile == null) {
                    ExternalDiffToolUtil.$$$reportNull$$$0(16);
                }
                return localOutputFile;
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName);
            NonLocalOutputFile nonLocalOutputFile = new NonLocalOutputFile(file2, tempFile);
            if (nonLocalOutputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(17);
            }
            return nonLocalOutputFile;
        }
        if (content instanceof DocumentContent) {
            File tempFile = ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName);
            DocumentOutputFile documentOutputFile = new DocumentOutputFile(((DocumentContent)content).getDocument(), ((DocumentContent)content).getCharset(), tempFile);
            if (documentOutputFile == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(18);
            }
            return documentOutputFile;
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createFile(@NotNull byte[] bytes, @NotNull FileNameInfo fileName) throws IOException {
        if (bytes == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(19);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(20);
        }
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file2 = tempFile;
        if (file2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(21);
        }
        return file2;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(22);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(23);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(24);
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files = new ArrayList<InputFile>();
        for (int i = 0; i < contents.size(); ++i) {
            DiffContent content = contents.get(i);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i);
            files.add(ExternalDiffToolUtil.createFile(content, fileName));
        }
        HashMap patterns = ContainerUtil.newHashMap();
        if (files.size() == 2) {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(2)).getPath());
            patterns.put("%3", ((InputFile)files.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project2, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        if (settings == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(25);
        }
        if (request == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(26);
        }
        boolean success = false;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                DiffContent content = (DiffContent)contents.get(i);
                FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i);
                inputFiles.add(ExternalDiffToolUtil.createFile(content, fileName));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            com.intellij.util.containers.hash.HashMap patterns = new com.intellij.util.containers.hash.HashMap();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), (Map<String, String>)patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Waiting for External Tool", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$1", "run"));
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Launching External Tool", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$2", "run"));
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project2, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
            throw throwable;
        }
        if (outputFile != null) {
            outputFile.cleanup();
        }
        for (InputFile file3 : inputFiles) {
            file3.cleanup();
        }
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        if (exePath == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(27);
        }
        if (parametersTemplate == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(28);
        }
        if (patterns == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(29);
        }
        List parameters2 = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter2 : parameters2) {
            String arg = StringUtil.replace((String)parameter2, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        Process process2 = generalCommandLine.createProcess();
        if (process2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(30);
        }
        return process2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersTemplate";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFile";
                break;
            }
            case 1: 
            case 2: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createOutputFile";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeMerge";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTempFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        public FileNameInfo(@NotNull String prefix, @NotNull String name2) {
            if (prefix == null) {
                FileNameInfo.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                FileNameInfo.$$$reportNull$$$0(1);
            }
            this.prefix = prefix;
            this.name = name2;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents == null) {
                FileNameInfo.$$$reportNull$$$0(2);
            }
            if (titles == null) {
                FileNameInfo.$$$reportNull$$$0(3);
            }
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name2 = FileNameInfo.getFileName(content, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name2);
                if (fileNameInfo == null) {
                    FileNameInfo.$$$reportNull$$$0(4);
                }
                return fileNameInfo;
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name3 = FileNameInfo.getFileName(content, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name3);
                if (fileNameInfo == null) {
                    FileNameInfo.$$$reportNull$$$0(5);
                }
                return fileNameInfo;
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content, @Nullable String windowTitle) {
            if (content == null) {
                FileNameInfo.$$$reportNull$$$0(6);
            }
            String name2 = FileNameInfo.getFileName(content, null, windowTitle);
            FileNameInfo fileNameInfo = new FileNameInfo("merge_result", name2);
            if (fileNameInfo == null) {
                FileNameInfo.$$$reportNull$$$0(7);
            }
            return fileNameInfo;
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content == null) {
                FileNameInfo.$$$reportNull$$$0(8);
            }
            if (content instanceof EmptyContent) {
                if ("no_content.tmp" == null) {
                    FileNameInfo.$$$reportNull$$$0(9);
                }
                return "no_content.tmp";
            }
            String fileName = (String)content.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content instanceof FileContent) {
                fileName = ((FileContent)content).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                String string = fileName;
                if (string == null) {
                    FileNameInfo.$$$reportNull$$$0(10);
                }
                return string;
            }
            FileType fileType = content.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            String name2 = "";
            if (title != null && windowTitle != null) {
                name2 = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                String string2 = name2 = title != null ? title : windowTitle;
            }
            if (name2.length() > 50) {
                name2 = name2.substring(0, 50);
            }
            String string3 = PathUtil.suggestFileName((String)(name2 + "." + ext), (boolean)true, (boolean)false);
            if (string3 == null) {
                FileNameInfo.$$$reportNull$$$0(11);
            }
            return string3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titles";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMergeResult";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createMergeResult";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        public TempInputFile(@NotNull File localFile) {
            if (localFile == null) {
                TempInputFile.$$$reportNull$$$0(0);
            }
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                TempInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        public LocalInputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalInputFile.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                LocalInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        public DocumentOutputFile(@NotNull Document document, @Nullable Charset charset, @NotNull File localFile) {
            if (document == null) {
                DocumentOutputFile.$$$reportNull$$$0(0);
            }
            if (localFile == null) {
                DocumentOutputFile.$$$reportNull$$$0(1);
            }
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset != null ? charset : Charset.defaultCharset();
        }

        @Override
        public void apply() throws IOException {
            String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        public NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            if (file2 == null) {
                NonLocalOutputFile.$$$reportNull$$$0(0);
            }
            if (localFile == null) {
                NonLocalOutputFile.$$$reportNull$$$0(1);
            }
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            this.myFile.setBinaryContent(FileUtil.loadFileBytes((File)this.myLocalFile));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        public LocalOutputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LocalOutputFile.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

