/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalMergeTool {
    private static final Logger LOG = Logger.getInstance(ExternalMergeTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isMergeEnabled();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isMergeEnabled();
    }

    public static void show(@Nullable Project project2, @NotNull MergeRequest request) {
        if (request == null) {
            ExternalMergeTool.$$$reportNull$$$0(0);
        }
        try {
            if (ExternalMergeTool.canShow(request)) {
                ExternalMergeTool.showRequest(project2, request);
            } else {
                DiffManagerEx.getInstance().showMergeBuiltin(project2, request);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)"Can't Show Merge In External Tool");
        }
    }

    public static void showRequest(@Nullable Project project2, @NotNull MergeRequest request) throws ExecutionException, IOException {
        if (request == null) {
            ExternalMergeTool.$$$reportNull$$$0(1);
        }
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        ExternalDiffToolUtil.executeMerge(project2, settings, (ThreesideMergeRequest)request);
    }

    public static boolean canShow(@NotNull MergeRequest request) {
        if (request == null) {
            ExternalMergeTool.$$$reportNull$$$0(2);
        }
        if (request instanceof ThreesideMergeRequest) {
            DiffContent outputContent = ((ThreesideMergeRequest)request).getOutputContent();
            if (!ExternalMergeTool.canProcessOutputContent(outputContent)) {
                return false;
            }
            List contents = ((ThreesideMergeRequest)request).getContents();
            if (contents.size() != 3) {
                return false;
            }
            for (DiffContent content : contents) {
                if (ExternalDiffToolUtil.canCreateFile(content)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean canProcessOutputContent(@NotNull DiffContent content) {
        if (content == null) {
            ExternalMergeTool.$$$reportNull$$$0(3);
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        return content instanceof FileContent && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/external/ExternalMergeTool";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canShow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessOutputContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

