/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final Logger LOGGER = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    private static final int SHORT_HASH_LENGTH = 8;
    private static final int LONG_HASH_LENGTH = 40;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(Repository::getPresentableUrl);

    @NotNull
    public static List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            DvcsUtil.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.sorted(virtualFiles, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<File> files) {
        if (files == null) {
            DvcsUtil.$$$reportNull$$$0(2);
        }
        RefreshVFsSynchronously.refreshFiles(files);
        List list2 = ContainerUtil.mapNotNull(files, file2 -> VfsUtil.findFileByIoFile((File)file2, (boolean)false));
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public static String getShortRepositoryName(@NotNull Project project2, @NotNull VirtualFile root) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            DvcsUtil.$$$reportNull$$$0(5);
        }
        String string = VcsImplUtil.getShortVcsRootName(project2, root);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            DvcsUtil.$$$reportNull$$$0(7);
        }
        String string = VcsImplUtil.getShortVcsRootName(repository.getProject(), repository.getRoot());
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(9);
        }
        String string = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String fileOrFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(11);
        }
        if (file2.isDirectory()) {
            if ("folder" == null) {
                DvcsUtil.$$$reportNull$$$0(12);
            }
            return "folder";
        }
        if ("file" == null) {
            DvcsUtil.$$$reportNull$$$0(13);
        }
        return "file";
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        String joined;
        if (messages == null) {
            DvcsUtil.$$$reportNull$$$0(14);
        }
        return StringUtil.isEmptyOrSpaces((String)(joined = StringUtil.join(messages, (String)"\n"))) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project2) {
        Editor editor;
        FileEditorManager manager;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(15);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project2, statusBar);
        VirtualFile result2 = null;
        if (fileEditor != null) {
            if (fileEditor instanceof TextEditor) {
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                result2 = FileDocumentManager.getInstance().getFile(document);
            } else if (fileEditor instanceof ImageFileEditor) {
                result2 = ((ImageFileEditor)fileEditor).getImageEditor().getFile();
            }
        }
        if (result2 == null && (manager = FileEditorManager.getInstance((Project)project2)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result2;
    }

    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            DvcsUtil.$$$reportNull$$$0(16);
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = hash.substring(0, Math.min(8, hash.length()));
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            DvcsUtil.$$$reportNull$$$0(18);
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project2) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(20);
        }
        BackgroundTaskUtil.syncPublisher(BatchFileChangeListener.TOPIC).batchChangeStarted(project2);
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                BackgroundTaskUtil.syncPublisher(BatchFileChangeListener.TOPIC).batchChangeCompleted(project2);
            }
        };
        if (accessToken == null) {
            DvcsUtil.$$$reportNull$$$0(21);
        }
        return accessToken;
    }

    @Deprecated
    public static void workingTreeChangeFinished(@NotNull Project project2, @NotNull AccessToken token) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(22);
        }
        if (token == null) {
            DvcsUtil.$$$reportNull$$$0(23);
        }
        token.finish();
    }

    public static void assertFileExists(File file2, String message2) throws IllegalStateException {
        if (!file2.exists()) {
            throw new IllegalStateException(message2);
        }
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file2) throws RepoStateException {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(24);
        }
        String string = DvcsUtil.tryLoadFile(file2, null);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file2, @Nullable String encoding) throws RepoStateException {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(26);
        }
        String string = DvcsUtil.tryOrThrow(() -> {
            if (file2 == null) {
                DvcsUtil.$$$reportNull$$$0(58);
            }
            return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file2, (String)encoding)).trim();
        }, file2);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable String defaultValue) {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(28);
        }
        return DvcsUtil.tryLoadFileOrReturn(file2, defaultValue, null);
    }

    @Nullable
    @Contract(value="_ , !null, _ -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable String defaultValue, @Nullable String encoding) {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(29);
        }
        try {
            return DvcsUtil.tryLoadFile(file2, encoding);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return defaultValue;
        }
    }

    private static <T> T tryOrThrow(Callable<T> actionToTry, File fileToLoad) throws RepoStateException {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            DvcsUtil.$$$reportNull$$$0(30);
        }
        if (subDirs == null) {
            DvcsUtil.$$$reportNull$$$0(31);
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)Processor.TRUE);
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project2, @NotNull String newRepositoryPath, @NotNull String vcsName) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(32);
        }
        if (newRepositoryPath == null) {
            DvcsUtil.$$$reportNull$$$0(33);
        }
        if (vcsName == null) {
            DvcsUtil.$$$reportNull$$$0(34);
        }
        if (!project2.isDisposed() && project2.getBasePath() != null && FileUtil.isAncestor((String)project2.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project2);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project2, @NotNull RepositoryManager<T> manager, @Nullable VirtualFile file2, @Nullable String defaultRootPathValue) {
        Repository repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(35);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(36);
        }
        return (T)((repository = manager.getRepositoryForRoot(DvcsUtil.guessVcsRoot(project2, file2))) != null ? repository : manager.getRepositoryForRoot(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue)));
    }

    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @Nullable String defaultRootPathValue) {
        T repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(37);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(38);
        }
        return (repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project2, DvcsUtil.getSelectedFile(project2)))) != null ? repository : manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project2, @Nullable AbstractVcs vcs, @Nullable String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(39);
        }
        if (project2.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        if (vcs == null) {
            LOG.debug("Vcs not found.");
            return null;
        }
        String vcsName = vcs.getDisplayName();
        VirtualFile[] vcsRoots = vcsManager.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && (recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project2.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        for (VirtualFile root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + root);
            return root;
        }
        VirtualFile rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<T> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(40);
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        Collections.sort(validRepositories, REPOSITORY_COMPARATOR);
        return validRepositories;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        ProjectLevelVcsManager vcsManager;
        VirtualFile root;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(41);
        }
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(42);
        }
        if ((root = (vcsManager = ProjectLevelVcsManager.getInstance((Project)project2)).getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file2))) != null) {
            LOGGER.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(file2);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.size() == 0) {
            LOGGER.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOGGER.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(43);
        }
        VirtualFile root = null;
        if (file2 != null && (root = ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootFor(file2)) == null) {
            LOGGER.debug("Cannot get root by file. Trying with get by library: " + file2);
            root = DvcsUtil.getVcsRootForLibraryFile(project2, file2);
        }
        return root;
    }

    @NotNull
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (repoManager == null) {
            DvcsUtil.$$$reportNull$$$0(44);
        }
        if (commits == null) {
            DvcsUtil.$$$reportNull$$$0(45);
        }
        HashMap groupedCommits = ContainerUtil.newHashMap();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            Repository repository = repoManager.getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOGGER.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = (List)groupedCommits.get(repository);
            if (commitsInRoot == null) {
                commitsInRoot = ContainerUtil.newArrayList();
                groupedCommits.put(repository, commitsInRoot);
            }
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap hashMap = groupedCommits;
        if (hashMap == null) {
            DvcsUtil.$$$reportNull$$$0(46);
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(47);
        }
        return (PushSupport)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)PushSupport.PUSH_SUPPORT_EP, (AreaInstance)vcs.getProject()), support -> {
            if (vcs == null) {
                DvcsUtil.$$$reportNull$$$0(57);
            }
            return support.getVcs().equals((Object)vcs);
        });
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(48);
        }
        String string = DvcsUtil.joinShortNames(repositories, -1);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(50);
        }
        String string = DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static String joinWithAnd(@NotNull List<String> strings, int limit) {
        int size;
        if (strings == null) {
            DvcsUtil.$$$reportNull$$$0(52);
        }
        if ((size = strings.size()) == 0) {
            if ("" == null) {
                DvcsUtil.$$$reportNull$$$0(53);
            }
            return "";
        }
        if (size == 1) {
            String string = strings.get(0);
            if (string == null) {
                DvcsUtil.$$$reportNull$$$0(54);
            }
            return string;
        }
        if (size == 2) {
            String string = strings.get(0) + " and " + strings.get(1);
            if (string == null) {
                DvcsUtil.$$$reportNull$$$0(55);
            }
            return string;
        }
        boolean isLimited = limit >= 2 && limit < size;
        int listCount = (isLimited ? limit : size) - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listCount; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(strings.get(i));
        }
        if (isLimited) {
            sb.append(" and ").append(size - limit + 1).append(" others");
        } else {
            sb.append(" and ").append(strings.get(size - 1));
        }
        String string = sb.toString();
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 15: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: 
            case 40: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 42: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDir";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositoryPath";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoManager";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 47: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVirtualFilesByPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFilesWithRefresh";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRepositoryName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fileOrFolder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateString";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "workingTreeChangeStarted";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "groupCommitsByRoots";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "joinShortNames";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortVirtualFilesByPresentation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFilesWithRefresh";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShortRepositoryName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShortNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fileOrFolder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "joinMessagesOrNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDateString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeStarted";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeFinished";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFileOrReturn";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitVcsDirVfs";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addMappingIfSubRoot";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepositoryQuick";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "guessRootForVcs";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sortRepositories";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootForLibraryFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "guessVcsRoot";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "groupCommitsByRoots";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupport";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "joinShortNames";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPushSupport$5";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryLoadFile$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

