/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushController
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;
    @NotNull
    private final List<PushSupport<Repository, PushSource, PushTarget>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    @Nullable
    private final Repository myCurrentlyOpenedRepository;
    private final List<PrePushHandler> myHandlers;
    private final boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    private final ExecutorService myExecutorService;
    private final Map<RepositoryNode, MyRepoModel<?, ?, ?>> myView2Model;

    public PushController(@NotNull Project project2, @NotNull VcsPushDialog dialog2, @NotNull List<? extends Repository> preselectedRepositories, @Nullable Repository currentRepo) {
        if (project2 == null) {
            PushController.$$$reportNull$$$0(0);
        }
        if (dialog2 == null) {
            PushController.$$$reportNull$$$0(1);
        }
        if (preselectedRepositories == null) {
            PushController.$$$reportNull$$$0(2);
        }
        this.myHandlers = ContainerUtil.newArrayList();
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"DVCS Push");
        this.myView2Model = new TreeMap();
        this.myProject = project2;
        ContainerUtil.addAll(this.myHandlers, (Object[])PrePushHandler.EP_NAME.getExtensions((AreaInstance)project2));
        this.myGlobalRepositoryManager = VcsRepositoryManager.getInstance(project2);
        this.myPreselectedRepositories = preselectedRepositories;
        this.myCurrentlyOpenedRepository = currentRepo;
        this.myPushSupports = this.getAffectedSupports();
        this.mySingleRepoProject = this.isSingleRepoProject();
        this.myDialog = dialog2;
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode, this.isSyncStrategiesAllowed());
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PushController.this.myDialog.enableOkActions((Boolean)evt.getNewValue() == false);
            }
        });
        this.startLoadingCommits();
        Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)this);
    }

    private boolean isSyncStrategiesAllowed() {
        return !this.mySingleRepoProject && ContainerUtil.and(this.getAffectedSupports(), support -> support.mayChangeTargetsSync());
    }

    private boolean isSingleRepoProject() {
        return this.myGlobalRepositoryManager.getRepositories().size() == 1;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> List<PushSupport<R, S, T>> getAffectedSupports() {
        Collection<Repository> repositories = this.myGlobalRepositoryManager.getRepositories();
        Set vcss = ContainerUtil.map2Set(repositories, repository -> repository.getVcs());
        List list2 = ContainerUtil.map((Collection)vcss, vcs -> DvcsUtil.getPushSupport(vcs));
        if (list2 == null) {
            PushController.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public boolean isForcePushEnabled() {
        return ContainerUtil.exists(this.myView2Model.values(), model -> model.getSupport().isForcePushEnabled());
    }

    @Nullable
    public PushTarget getProhibitedTarget() {
        MyRepoModel model = (MyRepoModel)ContainerUtil.find(this.myView2Model.values(), model1 -> {
            Object target2 = model1.getTarget();
            return model1.isSelected() && target2 != null && !model1.getSupport().isForcePushAllowed(model1.getRepository(), target2);
        });
        return model != null ? (PushTarget)model.getTarget() : null;
    }

    private void startLoadingCommits() {
        Object currentRepoModel;
        LinkedHashMap priorityLoading = ContainerUtil.newLinkedHashMap();
        LinkedHashMap others = ContainerUtil.newLinkedHashMap();
        RepositoryNode nodeForCurrentEditor = this.findNodeByRepo(this.myCurrentlyOpenedRepository);
        if (nodeForCurrentEditor != null && (this.isPreChecked((MyRepoModel)(currentRepoModel = this.myView2Model.get(nodeForCurrentEditor))) || this.myPreselectedRepositories.isEmpty())) {
            priorityLoading.put(nodeForCurrentEditor, currentRepoModel);
            ((MyRepoModel)currentRepoModel).setChecked(true);
        }
        for (Map.Entry entry : this.myView2Model.entrySet()) {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            RepositoryNode repoNode = (RepositoryNode)entry.getKey();
            if (this.isPreChecked(model)) {
                priorityLoading.putIfAbsent(repoNode, model);
                model.setChecked(true);
                continue;
            }
            if (!model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) continue;
            others.put(repoNode, model);
        }
        if (this.myPreselectedRepositories.isEmpty()) {
            boolean shouldScrollTo = this.myView2Model.values().stream().noneMatch(MyRepoModel::isSelected);
            this.myPushLog.highlightNodeOrFirst(nodeForCurrentEditor, shouldScrollTo);
        }
        this.loadCommitsFromMap(priorityLoading);
        this.loadCommitsFromMap(others);
    }

    private boolean isPreChecked(@NotNull MyRepoModel model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(4);
        }
        return Registry.is((String)"vcs.push.all.with.commits") || model.getSupport().getRepositoryManager().isSyncEnabled() || this.preselectByUser((Repository)model.getRepository());
    }

    private RepositoryNode findNodeByRepo(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myView2Model.entrySet(), entry1 -> {
            MyRepoModel model = (MyRepoModel)entry1.getValue();
            return model.getRepository().getRoot().equals(repository.getRoot());
        });
        return entry != null ? (RepositoryNode)entry.getKey() : null;
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel> items) {
        if (items == null) {
            PushController.$$$reportNull$$$0(5);
        }
        for (Map.Entry<RepositoryNode, MyRepoModel> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        if (rootNode == null) {
            PushController.$$$reportNull$$$0(6);
        }
        for (Repository repository : DvcsUtil.sortRepositories(this.myGlobalRepositoryManager.getRepositories())) {
            this.createRepoNode(repository, rootNode);
        }
    }

    @Nullable
    private <R extends Repository, S extends PushSource, T extends PushTarget> PushSupport<R, S, T> getPushSupportByRepository(@NotNull R repository) {
        if (repository == null) {
            PushController.$$$reportNull$$$0(7);
        }
        return (PushSupport)ContainerUtil.find(this.myPushSupports, support -> {
            if (repository == null) {
                PushController.$$$reportNull$$$0(45);
            }
            return support.getVcs().equals((Object)repository.getVcs());
        });
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull R repository, @NotNull CheckedTreeNode rootNode) {
        PushSupport<R, S, T> support;
        if (repository == null) {
            PushController.$$$reportNull$$$0(8);
        }
        if (rootNode == null) {
            PushController.$$$reportNull$$$0(9);
        }
        if ((support = this.getPushSupportByRepository(repository)) == null) {
            return;
        }
        PushTarget target2 = support.getDefaultTarget(repository);
        String repoName = this.getDisplayedRepoName(repository);
        PushSource source = support.getSource(repository);
        final MyRepoModel<R, PushSource, PushTarget> model = new MyRepoModel<R, PushSource, PushTarget>(repository, support, this.mySingleRepoProject, source, target2);
        if (target2 == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = support.createTargetPanel(repository, target2);
        final RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        CheckBoxModel checkBoxModel = model.getCheckBoxModel();
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel, checkBoxModel) : new RepositoryNode(repoPanel, checkBoxModel, target2 != null);
        pushTargetPanel.setFireOnChangeAction(new Runnable(){

            @Override
            public void run() {
                repoPanel.fireOnChange();
                ((DefaultTreeModel)PushController.this.myPushLog.getTree().getModel()).nodeChanged((TreeNode)((Object)repoNode));
            }
        });
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                repoNode.setChecked(true);
                if (!newTarget.equals(model.getTarget()) || model.hasError() || !model.hasCommitInfo()) {
                    model.setTarget(newTarget);
                    model.clearErrors();
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                PushController.this.myDialog.updateOkActions();
                if (isSelected && !model.hasCommitInfo() && !model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) {
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onTargetInEditMode(@NotNull String currentValue) {
                if (currentValue == null) {
                    3.$$$reportNull$$$0(0);
                }
                PushController.this.myPushLog.fireEditorUpdated(currentValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/intellij/dvcs/push/PushController$3", "onTargetInEditMode"));
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        String name2;
        int slash;
        if (repository == null) {
            PushController.$$$reportNull$$$0(10);
        }
        if ((slash = (name2 = DvcsUtil.getShortRepositoryName(repository)).lastIndexOf(File.separatorChar)) < 0) {
            String string = name2;
            if (string == null) {
                PushController.$$$reportNull$$$0(11);
            }
            return string;
        }
        String candidate = name2.substring(slash + 1);
        String string = !this.containedInOtherNames(repository, candidate) ? candidate : name2;
        if (string == null) {
            PushController.$$$reportNull$$$0(12);
        }
        return string;
    }

    private boolean containedInOtherNames(@NotNull Repository except, String candidate) {
        if (except == null) {
            PushController.$$$reportNull$$$0(13);
        }
        return ContainerUtil.exists(this.myGlobalRepositoryManager.getRepositories(), repository -> {
            if (except == null) {
                PushController.$$$reportNull$$$0(44);
            }
            return !repository.equals(except) && repository.getRoot().getName().equals(candidate);
        });
    }

    public boolean isPushAllowed() {
        CheckboxTree tree = this.myPushLog.getTree();
        return !((JTree)((Object)tree)).isEditing() && ContainerUtil.exists(this.myPushSupports, support -> this.isPushAllowed((PushSupport<?, ?, ?>)support));
    }

    private boolean isPushAllowed(@NotNull PushSupport<?, ?, ?> pushSupport) {
        if (pushSupport == null) {
            PushController.$$$reportNull$$$0(14);
        }
        return ContainerUtil.exists(this.getNodesForSupport(pushSupport), node -> node.isChecked() && this.myView2Model.get(node).getTarget() != null);
    }

    @NotNull
    private Collection<RepositoryNode> getNodesForSupport(PushSupport<?, ?, ?> support) {
        List list2 = ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> support.equals(((MyRepoModel)entry.getValue()).getSupport()) ? (RepositoryNode)entry.getKey() : null);
        if (list2 == null) {
            PushController.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static boolean hasLoadingNodes(@NotNull Collection<RepositoryNode> nodes) {
        if (nodes == null) {
            PushController.$$$reportNull$$$0(16);
        }
        return ContainerUtil.exists(nodes, node -> node.isLoading());
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(@NotNull MyRepoModel<R, S, T> model, @NotNull RepositoryNode node, boolean initial) {
        if (model == null) {
            PushController.$$$reportNull$$$0(17);
        }
        if (node == null) {
            PushController.$$$reportNull$$$0(18);
        }
        node.cancelLoading();
        T target2 = model.getTarget();
        if (target2 == null) {
            node.stopLoading();
            return;
        }
        node.setEnabled(true);
        PushSupport support = model.getSupport();
        AtomicReference result2 = new AtomicReference();
        Runnable task = () -> {
            if (model == null) {
                PushController.$$$reportNull$$$0(38);
            }
            if (node == null) {
                PushController.$$$reportNull$$$0(39);
            }
            Object repository = model.getRepository();
            OutgoingResult outgoing = support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), initial);
            result2.compareAndSet(null, outgoing);
            UIUtil.invokeAndWaitIfNeeded(() -> {
                boolean shouldBeSelected;
                OutgoingResult outgoing1;
                List errors;
                if (model == null) {
                    PushController.$$$reportNull$$$0(40);
                }
                if (node == null) {
                    PushController.$$$reportNull$$$0(41);
                }
                if (!(errors = (outgoing1 = (OutgoingResult)result2.get()).getErrors()).isEmpty()) {
                    shouldBeSelected = false;
                    model.setLoadedCommits(ContainerUtil.emptyList());
                    this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), ContainerUtil.map((Collection)errors, error -> {
                        if (node == null) {
                            PushController.$$$reportNull$$$0(42);
                        }
                        if (model == null) {
                            PushController.$$$reportNull$$$0(43);
                        }
                        VcsLinkedTextComponent errorLinkText = new VcsLinkedTextComponent(error.getText(), new VcsLinkListener((VcsError)error, node, model){
                            final /* synthetic */ VcsError val$error;
                            final /* synthetic */ RepositoryNode val$node;
                            final /* synthetic */ MyRepoModel val$model;
                            {
                                this.val$error = vcsError;
                                this.val$node = repositoryNode;
                                this.val$model = myRepoModel;
                            }

                            @Override
                            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                                if (sourceNode == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                if (event == null) {
                                    4.$$$reportNull$$$0(1);
                                }
                                this.val$error.handleError(new CommitLoader(){

                                    public void reloadCommits() {
                                        val$node.setChecked(true);
                                        PushController.this.loadCommits(val$model, val$node, false);
                                    }
                                });
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "sourceNode";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "event";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/dvcs/push/PushController$4";
                                objectArray[2] = "hyperlinkActivated";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        return new TextWithLinkNode(errorLinkText);
                    }));
                    if (node.isChecked()) {
                        node.setChecked(false);
                    }
                } else {
                    List commits = outgoing1.getCommits();
                    model.setLoadedCommits(commits);
                    shouldBeSelected = this.shouldSelectNodeAfterLoad(model);
                    this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), this.getPresentationForCommits(this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                    if (!commits.isEmpty() && shouldBeSelected) {
                        this.myPushLog.selectIfNothingSelected((TreeNode)((Object)node));
                    }
                }
                node.stopLoading();
                this.updateLoadingPanel();
                if (shouldBeSelected) {
                    node.setChecked(true);
                } else if (initial) {
                    node.setChecked(false);
                }
                this.myDialog.updateOkActions();
            });
        };
        node.startLoading((JTree)((Object)this.myPushLog.getTree()), this.myExecutorService.submit(task, result2), initial);
        this.updateLoadingPanel();
    }

    private void updateLoadingPanel() {
        this.myPushLog.getTree().setPaintBusy(PushController.hasLoadingNodes(this.myView2Model.keySet()));
    }

    private boolean shouldSelectNodeAfterLoad(@NotNull MyRepoModel model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(19);
        }
        if (this.mySingleRepoProject) {
            return true;
        }
        return model.isSelected() && (PushController.hasCommitsToPush(model) || !model.getSupport().getRepositoryManager().isSyncEnabled() && !Registry.is((String)"vcs.push.all.with.commits"));
    }

    private boolean preselectByUser(@NotNull Repository repository) {
        if (repository == null) {
            PushController.$$$reportNull$$$0(20);
        }
        return this.mySingleRepoProject || this.myPreselectedRepositories.contains(repository);
    }

    private static boolean hasCommitsToPush(@NotNull MyRepoModel model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(21);
        }
        Object target2 = model.getTarget();
        assert (target2 != null);
        return !model.getLoadedCommits().isEmpty() || target2.hasSomethingToPush();
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    @NotNull
    public PrePushHandler.Result executeHandlers(@NotNull ProgressIndicator indicator) throws ProcessCanceledException, HandlerException {
        if (indicator == null) {
            PushController.$$$reportNull$$$0(22);
        }
        if (this.myHandlers.isEmpty()) {
            PrePushHandler.Result result2 = PrePushHandler.Result.OK;
            if (result2 == null) {
                PushController.$$$reportNull$$$0(23);
            }
            return result2;
        }
        List<PushInfo> pushDetails = this.preparePushDetails();
        StepsProgressIndicator stepsIndicator = new StepsProgressIndicator(indicator, this.myHandlers.size());
        stepsIndicator.setIndeterminate(false);
        stepsIndicator.setFraction(0.0);
        for (PrePushHandler handler2 : this.myHandlers) {
            PrePushHandler.Result prePushHandlerResult;
            stepsIndicator.checkCanceled();
            stepsIndicator.setText(handler2.getPresentableName());
            try {
                prePushHandlerResult = handler2.handle(pushDetails, (ProgressIndicator)stepsIndicator);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                throw new HandlerException(handler2.getPresentableName(), e);
            }
            if (prePushHandlerResult != PrePushHandler.Result.OK) {
                PrePushHandler.Result result3 = prePushHandlerResult;
                if (result3 == null) {
                    PushController.$$$reportNull$$$0(24);
                }
                return result3;
            }
            stepsIndicator.setIndeterminate(false);
            stepsIndicator.nextStep();
        }
        PrePushHandler.Result result4 = PrePushHandler.Result.OK;
        if (result4 == null) {
            PushController.$$$reportNull$$$0(25);
        }
        return result4;
    }

    public void push(final boolean force) {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Pushing...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (PushSupport support : PushController.this.myPushSupports) {
                    PushController.this.doPushSynchronously(support, force);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$5", "run"));
            }
        };
        task.queue();
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPushSynchronously(@NotNull PushSupport<R, S, T> support, boolean force) {
        if (support == null) {
            PushController.$$$reportNull$$$0(26);
        }
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        Map<R, PushSpec<S, T>> specs = this.collectPushSpecsForVcs(support);
        if (!specs.isEmpty()) {
            pusher.push(specs, options, force);
        }
    }

    private static <R extends Repository, S extends PushSource, T extends PushTarget> List<? extends VcsFullCommitDetails> loadCommits(@NotNull MyRepoModel<R, S, T> model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(27);
        }
        PushSupport<R, S, T> support = model.getSupport();
        R repository = model.getRepository();
        S source = model.getSource();
        T target2 = model.getTarget();
        if (target2 == null) {
            return ContainerUtil.emptyList();
        }
        OutgoingCommitsProvider outgoingCommitsProvider = support.getOutgoingCommitsProvider();
        return outgoingCommitsProvider.getOutgoingCommits(repository, new PushSpec(source, target2), true).getCommits();
    }

    @NotNull
    private List<PushInfo> preparePushDetails() {
        ArrayList allDetails = ContainerUtil.newArrayList();
        Collection<MyRepoModel<?, ?, ?>> repoModels = this.getSelectedRepoNode();
        for (MyRepoModel<?, ?, ?> model : repoModels) {
            Object target2 = model.getTarget();
            if (target2 == null) continue;
            PushSpec pushSpec = new PushSpec(model.getSource(), target2);
            ArrayList loadedCommits = ContainerUtil.newArrayList();
            loadedCommits.addAll(model.getLoadedCommits());
            if (loadedCommits.isEmpty()) {
                loadedCommits.addAll(PushController.loadCommits(model));
            }
            Collections.reverse(loadedCommits);
            allDetails.add(new PushInfoImpl((Repository)model.getRepository(), pushSpec, loadedCommits));
        }
        List<PushInfo> list2 = Collections.unmodifiableList(allDetails);
        if (list2 == null) {
            PushController.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        if (pushSupport == null) {
            PushController.$$$reportNull$$$0(29);
        }
        HashMap pushSpecs = ContainerUtil.newHashMap();
        Collection<MyRepoModel<?, ?, ?>> repositoriesInformation = this.getSelectedRepoNode();
        for (MyRepoModel<?, ?, ?> repoModel : repositoriesInformation) {
            Object target2;
            if (!pushSupport.equals(repoModel.getSupport()) || (target2 = repoModel.getTarget()) == null) continue;
            pushSpecs.put(repoModel.getRepository(), new PushSpec(repoModel.getSource(), target2));
        }
        HashMap hashMap = pushSpecs;
        if (hashMap == null) {
            PushController.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    private Collection<MyRepoModel<?, ?, ?>> getSelectedRepoNode() {
        if (this.mySingleRepoProject) {
            return this.myView2Model.values();
        }
        return ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            return model.isSelected() && model.getTarget() != null ? model : null;
        });
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            PushController.$$$reportNull$$$0(31);
        }
        return project2;
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel<?, ?, ?> repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    private List<DefaultMutableTreeNode> getPresentationForCommits(@NotNull Project project2, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        if (project2 == null) {
            PushController.$$$reportNull$$$0(32);
        }
        if (commits == null) {
            PushController.$$$reportNull$$$0(33);
        }
        Function commitToNode = commit -> {
            if (project2 == null) {
                PushController.$$$reportNull$$$0(37);
            }
            return new CommitNode(project2, (VcsFullCommitDetails)commit);
        };
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < commits.size(); ++i) {
            if (i >= commitsNum) {
                VcsLinkedTextComponent moreCommitsLink = new VcsLinkedTextComponent("<a href='loadMore'>...</a>", new VcsLinkListener(){

                    @Override
                    public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                        TreeNode parent;
                        if (sourceNode == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            6.$$$reportNull$$$0(1);
                        }
                        if ((parent = sourceNode.getParent()) instanceof RepositoryNode) {
                            PushController.this.addMoreCommits((RepositoryNode)((Object)parent));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "sourceNode";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/dvcs/push/PushController$6";
                        objectArray[2] = "hyperlinkActivated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i)));
        }
        ArrayList<DefaultMutableTreeNode> arrayList = childrenToShown;
        if (arrayList == null) {
            PushController.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public Map<PushSupport, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), (Map)result2);
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            PushController.$$$reportNull$$$0(35);
        }
        return linkedHashMap;
    }

    public boolean ensureForcePushIsNeeded() {
        Collection<MyRepoModel<?, ?, ?>> selectedNodes = this.getSelectedRepoNode();
        MyRepoModel selectedModel = (MyRepoModel)ContainerUtil.getFirstItem(selectedNodes);
        if (selectedModel == null) {
            return false;
        }
        PushSupport activePushSupport = selectedModel.getSupport();
        PushTarget commonTarget = PushController.getCommonTarget(selectedNodes);
        if (commonTarget != null && activePushSupport.isSilentForcePushAllowed(commonTarget)) {
            return true;
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)DvcsBundle.message("push.force.confirmation.text", commonTarget != null ? " to <b>" + commonTarget.getPresentation() + "</b>" : "")), (String)"Force Push", (String)"&Force Push", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)(commonTarget != null ? new MyDoNotAskOptionForPush(activePushSupport, commonTarget) : null)) == 0;
    }

    @Nullable
    private static PushTarget getCommonTarget(@NotNull Collection<MyRepoModel<?, ?, ?>> selectedNodes) {
        Object commonTarget;
        if (selectedNodes == null) {
            PushController.$$$reportNull$$$0(36);
        }
        return (commonTarget = ((MyRepoModel)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(selectedNodes))).getTarget()) != null && !ContainerUtil.exists(selectedNodes, model -> !commonTarget.equals(model.getTarget())) ? (PushTarget)commonTarget : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedRepositories";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/PushController";
                break;
            }
            case 4: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 20: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 13: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "except";
                break;
            }
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 18: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/PushController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedSupports";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedRepoName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesForSupport";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "executeHandlers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePushDetails";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPushSpecsForVcs";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationForCommits";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalPanels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPreChecked";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitsFromMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTreeModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupportByRepository";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRepoNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayedRepoName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containedInOtherNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPushAllowed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadingNodes";
                break;
            }
            case 17: 
            case 18: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadCommits";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectNodeAfterLoad";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "preselectByUser";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasCommitsToPush";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeHandlers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doPushSynchronously";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectPushSpecsForVcs";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationForCommits";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTarget";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPresentationForCommits$16";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadCommits$14";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$13";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$12";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containedInOtherNames$7";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPushSupportByRepository$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDoNotAskOptionForPush
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final PushSupport myActivePushSupport;
        @NotNull
        private final PushTarget myCommonTarget;

        public MyDoNotAskOptionForPush(@NotNull PushSupport support, @NotNull PushTarget target2) {
            if (support == null) {
                MyDoNotAskOptionForPush.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                MyDoNotAskOptionForPush.$$$reportNull$$$0(1);
            }
            this.myActivePushSupport = support;
            this.myCommonTarget = target2;
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            if (!toBeShown && exitCode == 0) {
                this.myActivePushSupport.saveSilentForcePushTarget(this.myCommonTarget);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Don't warn about this target" == null) {
                MyDoNotAskOptionForPush.$$$reportNull$$$0(2);
            }
            return "Don't warn about this target";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDoNotShowMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        private final Repo myRepository;
        @NotNull
        private final PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits;
        @NotNull
        private final CheckBoxModel myCheckBoxModel;

        public MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target2) {
            if (repository == null) {
                MyRepoModel.$$$reportNull$$$0(0);
            }
            if (supportForRepo == null) {
                MyRepoModel.$$$reportNull$$$0(1);
            }
            if (source == null) {
                MyRepoModel.$$$reportNull$$$0(2);
            }
            this.myLoadedCommits = Collections.emptyList();
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myCheckBoxModel = new CheckBoxModel(isSelected);
            this.mySource = source;
            this.myTarget = target2;
            this.myNumberOfShownCommits = 20;
        }

        @NotNull
        public Repo getRepository() {
            Repo Repo2 = this.myRepository;
            if (Repo2 == null) {
                MyRepoModel.$$$reportNull$$$0(3);
            }
            return Repo2;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            PushSupport<Repo, S, T> pushSupport = this.mySupport;
            if (pushSupport == null) {
                MyRepoModel.$$$reportNull$$$0(4);
            }
            return pushSupport;
        }

        @NotNull
        public S getSource() {
            S s = this.mySource;
            if (s == null) {
                MyRepoModel.$$$reportNull$$$0(5);
            }
            return s;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target2) {
            this.myTarget = target2;
        }

        public boolean isSelected() {
            return this.myCheckBoxModel.isChecked();
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            List<? extends VcsFullCommitDetails> list2 = this.myLoadedCommits;
            if (list2 == null) {
                MyRepoModel.$$$reportNull$$$0(6);
            }
            return list2;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            if (loadedCommits == null) {
                MyRepoModel.$$$reportNull$$$0(7);
            }
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }

        @NotNull
        public CheckBoxModel getCheckBoxModel() {
            CheckBoxModel checkBoxModel = this.myCheckBoxModel;
            if (checkBoxModel == null) {
                MyRepoModel.$$$reportNull$$$0(8);
            }
            return checkBoxModel;
        }

        public void setChecked(boolean checked) {
            this.myCheckBoxModel.setChecked(checked);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supportForRepo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$MyRepoModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$MyRepoModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupport";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSource";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoadedCommits";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckBoxModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLoadedCommits";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PushInfoImpl
    implements PushInfo {
        private final Repository myRepository;
        private final PushSpec<PushSource, PushTarget> myPushSpec;
        private final List<VcsFullCommitDetails> myCommits;

        private PushInfoImpl(@NotNull Repository repository, @NotNull PushSpec<PushSource, PushTarget> spec, @NotNull List<VcsFullCommitDetails> commits) {
            if (repository == null) {
                PushInfoImpl.$$$reportNull$$$0(0);
            }
            if (spec == null) {
                PushInfoImpl.$$$reportNull$$$0(1);
            }
            if (commits == null) {
                PushInfoImpl.$$$reportNull$$$0(2);
            }
            this.myRepository = repository;
            this.myPushSpec = spec;
            this.myCommits = commits;
        }

        @Override
        @NotNull
        public Repository getRepository() {
            Repository repository = this.myRepository;
            if (repository == null) {
                PushInfoImpl.$$$reportNull$$$0(3);
            }
            return repository;
        }

        @Override
        @NotNull
        public PushSpec<PushSource, PushTarget> getPushSpec() {
            PushSpec<PushSource, PushTarget> pushSpec = this.myPushSpec;
            if (pushSpec == null) {
                PushInfoImpl.$$$reportNull$$$0(4);
            }
            return pushSpec;
        }

        @Override
        @NotNull
        public List<VcsFullCommitDetails> getCommits() {
            List<VcsFullCommitDetails> list2 = this.myCommits;
            if (list2 == null) {
                PushInfoImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$PushInfoImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$PushInfoImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushSpec";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StepsProgressIndicator
    extends DelegatingProgressIndicator {
        private final int myTotalSteps;
        private final AtomicInteger myFinishedTasks;

        public StepsProgressIndicator(@NotNull ProgressIndicator indicator, int totalSteps) {
            if (indicator == null) {
                StepsProgressIndicator.$$$reportNull$$$0(0);
            }
            super(indicator);
            this.myFinishedTasks = new AtomicInteger();
            this.myTotalSteps = totalSteps;
        }

        public void nextStep() {
            this.myFinishedTasks.incrementAndGet();
            this.setFraction(0.0);
        }

        public void setFraction(double fraction) {
            super.setFraction(((double)this.myFinishedTasks.get() + fraction) / (double)this.myTotalSteps);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$StepsProgressIndicator", "<init>"));
        }
    }

    public static class HandlerException
    extends RuntimeException {
        private final String myHandlerName;

        public HandlerException(@NotNull String name2, @NotNull Throwable cause) {
            if (name2 == null) {
                HandlerException.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                HandlerException.$$$reportNull$$$0(1);
            }
            super(cause);
            this.myHandlerName = name2;
        }

        @NotNull
        public String getHandlerName() {
            String string = this.myHandlerName;
            if (string == null) {
                HandlerException.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$HandlerException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$HandlerException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandlerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

