/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper {
    private static final String ID = "Vcs.Push.Dialog";
    private final PushLog myListPanel;
    private final PushController myController;
    private final Map<PushSupport, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myPushAction;
    @Nullable
    private ForcePushAction myForcePushAction;

    public VcsPushDialog(@NotNull Project project2, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project2 == null) {
            VcsPushDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(1);
        }
        super(project2, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myController = new PushController(project2, this, selectedRepositories, currentRepo);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.init();
        this.updateOkActions();
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Push Commits");
    }

    protected JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowx"));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            optionsPanel.add((Component)panel2);
        }
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        BorderLayoutPanel panel3 = JBUI.Panels.simplePanel((Component)optionsPanel);
        if (!this.myController.isForcePushEnabled()) {
            panel3.addToTop((Component)this.createForcePushInfoLabel());
        }
        return JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)panel3);
    }

    @NotNull
    private JComponent createForcePushInfoLabel() {
        JPanel text2 = new JPanel();
        text2.setLayout(new BoxLayout(text2, 0));
        JLabel label = new JLabel("You can enable and configure Force Push in " + ShowSettingsUtil.getSettingsMenuName() + ".");
        label.setEnabled(false);
        label.setFont((Font)JBUI.Fonts.smallFont());
        text2.add(label);
        ActionLink here = new ActionLink("Configure", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Project project2 = VcsPushDialog.this.myController.getProject();
                VcsPushDialog.this.doCancelAction(e.getInputEvent());
                ShowSettingsUtilImpl.showSettingsDialog(project2, "vcs.Git", "force push");
            }
        });
        here.setFont((Font)JBUI.Fonts.smallFont());
        text2.add((Component)here);
        JBPanel jBPanel = JBUI.Panels.simplePanel().addToRight((Component)text2).withBorder((Border)JBUI.Borders.emptyBottom((int)4));
        if (jBPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(2);
        }
        return jBPanel;
    }

    protected String getDimensionServiceKey() {
        return ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myForcePushAction = new ForcePushAction();
        this.myForcePushAction.setEnabled(this.canForcePush());
        this.myForcePushAction.putValue("Name", "&Force Push");
        if (this.myController.isForcePushEnabled()) {
            this.myPushAction = new ComplexPushAction(this.myForcePushAction);
        } else {
            this.myPushAction = new DialogWrapper.OkAction(){};
            this.myPushAction.putValue("Name", "&Push");
        }
        this.myPushAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myPushAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            VcsPushDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private boolean canPush() {
        return this.myController.isPushAllowed();
    }

    private boolean canForcePush() {
        return this.myController.isForcePushEnabled() && this.myController.getProhibitedTarget() == null && this.myController.isPushAllowed();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myPushAction;
        if (action == null) {
            VcsPushDialog.$$$reportNull$$$0(4);
        }
        return action;
    }

    protected String getHelpId() {
        return ID;
    }

    private void push(final boolean forcePush) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), "Checking Commits...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onSuccess() {
                super.onSuccess();
                if (result2.get() == PrePushHandler.Result.OK) {
                    this.doPush();
                } else if (result2.get() == PrePushHandler.Result.ABORT_AND_CLOSE) {
                    VcsPushDialog.this.doCancelAction();
                } else if (result2.get() == PrePushHandler.Result.ABORT) {
                    // empty if block
                }
            }

            private void doPush() {
                VcsPushDialog.this.myController.push(forcePush);
                VcsPushDialog.this.close(0);
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (error instanceof PushController.HandlerException) {
                    super.onThrowable(error.getCause());
                    String handlerName = ((PushController.HandlerException)error).getHandlerName();
                    this.suggestToSkipOrPush(handlerName + " has failed. See log for more details.\nWould you like to skip pre-push checking and continue or cancel push completely?");
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush("Would you like to skip pre-push checking and continue or cancel push completely?");
            }

            private void suggestToSkipOrPush(@NotNull String message2) {
                if (message2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)"Push", (String)"&Push Anyway", (String)"&Cancel", (Icon)UIUtil.getWarningIcon()) == 0) {
                    this.doPush();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestToSkipOrPush";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    public void updateOkActions() {
        this.myPushAction.setEnabled(this.canPush());
        if (this.myForcePushAction != null) {
            boolean canForcePush = this.canForcePush();
            this.myForcePushAction.setEnabled(canForcePush);
            String tooltip = null;
            if (!canForcePush) {
                PushTarget target2 = this.myController.getProhibitedTarget();
                tooltip = this.myController.isForcePushEnabled() && target2 != null ? "Force push to <b>" + target2.getPresentation() + "</b> is prohibited" : "<b>Force Push</b> can be enabled in the Settings";
            }
            this.myForcePushAction.putValue("ShortDescription", tooltip);
        }
    }

    public void enableOkActions(boolean value2) {
        this.myPushAction.setEnabled(value2);
    }

    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2;
        if (support == null) {
            VcsPushDialog.$$$reportNull$$$0(5);
        }
        return (panel2 = this.myAdditionalPanels.get(support)) == null ? null : panel2.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createForcePushInfoLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final Action[] myOptions;

        private ComplexPushAction(Action additionalAction) {
            super("&Push");
            this.myOptions = new Action[]{additionalAction};
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsPushDialog.this.push(false);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action optionAction : this.myOptions) {
                optionAction.setEnabled(isEnabled);
            }
        }

        @NotNull
        public Action[] getOptions() {
            if (this.myOptions == null) {
                ComplexPushAction.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction", "getOptions"));
        }
    }

    private class ForcePushAction
    extends AbstractAction {
        ForcePushAction() {
            super("&Force Push");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VcsPushDialog.this.myController.ensureForcePushIsNeeded()) {
                VcsPushDialog.this.push(true);
            }
        }
    }
}

