/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log.requestSelectedDetails(details -> {
            MultiMap grouped = this.groupCommits(project2, (Collection)details, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project2, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project2 == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project2, log);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project2, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project2, @NotNull MultiMap<Repo, Hash> grouped) {
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(2);
        }
        if (grouped == null) {
            VcsLogAction.$$$reportNull$$$0(3);
        }
        AbstractRepositoryManager manager = this.getRepositoryManager(project2);
        return grouped.keySet().stream().allMatch(repo -> !manager.isExternal((Repository)repo));
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project2, @NotNull VcsLog log) {
        MultiMap commitIds;
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(4);
        }
        if (log == null) {
            VcsLogAction.$$$reportNull$$$0(5);
        }
        if ((commitIds = this.groupCommits(project2, VcsLogUtil.collectFirstPack(log.getSelectedCommits(), 1000), CommitId::getRoot)) == null) {
            return null;
        }
        MultiMap hashes = MultiMap.create();
        for (Map.Entry entry : commitIds.entrySet()) {
            hashes.putValues(entry.getKey(), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), CommitId::getHash));
        }
        return hashes;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project2, @NotNull Collection<T> commits, @NotNull Function<T, VirtualFile> rootGetter) {
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(6);
        }
        if (commits == null) {
            VcsLogAction.$$$reportNull$$$0(7);
        }
        if (rootGetter == null) {
            VcsLogAction.$$$reportNull$$$0(8);
        }
        MultiMap map = MultiMap.create();
        for (T commit : commits) {
            Repo root = this.getRepositoryForRoot(project2, (VirtualFile)rootGetter.fun(commit));
            if (root == null) {
                return null;
            }
            map.putValue(root, commit);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/VcsLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "groupFirstPackOfCommits";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "groupCommits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

