/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(@NotNull String executorId, RunnerAndConfigurationSettings configuration) {
        if (executorId == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(0);
        }
        return configuration == null ? null : RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        if (environment == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(1);
        }
        ProgramRunnerUtil.executeConfigurationAsync(environment, showSettings, assignNewId, null);
    }

    @NotNull
    public static String getCannotRunOnErrorMessage(@NotNull RunProfile profile2, @NotNull ExecutionTarget target2) {
        if (profile2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(3);
        }
        String string = StringUtil.escapeXml((String)("Cannot run '" + profile2.getName() + "' on '" + target2.getDisplayName() + "'"));
        if (string == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void executeConfigurationAsync(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId, ProgramRunner.Callback callback) {
        if (environment == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(5);
        }
        if (ExecutorRegistry.getInstance().isStarting(environment)) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        Project project2 = environment.getProject();
        if (runnerAndConfigurationSettings != null) {
            if (!ExecutionTargetManager.canRun((ExecutionEnvironment)environment)) {
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage(environment.getRunProfile(), environment.getExecutionTarget())));
                return;
            }
            if ((!RunManagerImpl.canRunConfiguration(environment) || showSettings && runnerAndConfigurationSettings.isEditBeforeRun()) && !DumbService.isDumb((Project)project2)) {
                if (!RunDialog.editConfiguration(environment, "Edit configuration")) {
                    return;
                }
                while (!RunManagerImpl.canRunConfiguration(environment) && 0 == Messages.showYesNoDialog((Project)project2, (String)"Configuration is still incorrect. Do you want to edit it again?", (String)"Change Configuration Settings", (String)"Edit", (String)"Continue Anyway", (Icon)Messages.getErrorIcon())) {
                    if (RunDialog.editConfiguration(environment, "Edit configuration")) continue;
                    return;
                }
            }
            UsageTrigger.trigger("execute." + ConvertUsagesUtil.ensureProperKey(runnerAndConfigurationSettings.getType().getId()) + "." + environment.getExecutor().getId());
        }
        try {
            if (assignNewId) {
                environment.assignNewExecutionId();
            }
            if (callback != null) {
                environment.getRunner().execute(environment, callback);
            } else {
                environment.getRunner().execute(environment);
            }
        }
        catch (ExecutionException e) {
            ProgramRunnerUtil.handleExecutionError(project2, environment, e, (RunProfile)(runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null));
        }
    }

    public static void handleExecutionError(Project project2, @NotNull ExecutionEnvironment environment, Throwable e, RunProfile configuration) {
        String name2;
        if (environment == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(6);
        }
        String string = name2 = configuration != null ? configuration.getName() : null;
        if (name2 == null) {
            name2 = environment.getRunProfile().getName();
        }
        if (name2 == null && environment.getContentToReuse() != null) {
            name2 = environment.getContentToReuse().getDisplayName();
        }
        if (name2 == null) {
            name2 = "<Unknown>";
        }
        String windowId = ExecutionManager.getInstance((Project)project2).getContentManager().getToolWindowIdByEnvironment(environment);
        if (configuration instanceof ConfigurationWithCommandLineShortener && ExecutionUtil.isProcessNotCreated((Throwable)e)) {
            ProgramRunnerUtil.handelProcessNotStartedError((ConfigurationWithCommandLineShortener)configuration, (ExecutionException)((ProcessNotCreatedException)e), name2, windowId);
        } else {
            ExecutionUtil.handleExecutionError((Project)project2, (String)windowId, (String)name2, (Throwable)e);
        }
    }

    private static void handelProcessNotStartedError(ConfigurationWithCommandLineShortener configuration, ExecutionException e, String name2, String windowId) {
        String description = e.getMessage();
        HyperlinkListener listener2 = null;
        Project project2 = configuration.getProject();
        RunManager runManager = RunManager.getInstance((Project)project2);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getAllSettings().stream().filter(settings -> settings.getConfiguration() == configuration).findFirst().orElse(null);
        if (runnerAndConfigurationSettings != null && (configuration.getShortenCommandLine() == null || configuration.getShortenCommandLine() == ShortenCommandLine.NONE)) {
            ConfigurationFactory factory = runnerAndConfigurationSettings.getFactory();
            RunnerAndConfigurationSettings configurationTemplate = runManager.getConfigurationTemplate(factory);
            description = "Command line is too long. Shorten command line for <a href=\"current\">" + name2 + "</a>";
            if (((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine() == null) {
                description = description + " or also for " + factory.getName() + " <a href=\"default\">default</a> configuration";
            }
            description = description + ".";
            listener2 = event -> {
                boolean isDefaultConfigurationChosen;
                SingleConfigurableEditor dialog2;
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (dialog2 = RunDialog.editShortenClasspathSetting((isDefaultConfigurationChosen = "default".equals(event.getDescription())) ? configurationTemplate : runnerAndConfigurationSettings, "Edit" + (isDefaultConfigurationChosen ? " Default" : "") + " Configuration")).showAndGet() && isDefaultConfigurationChosen) {
                    configuration.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine());
                }
            };
        }
        ExecutionUtil.handleExecutionError((Project)project2, (String)windowId, (String)name2, (Throwable)e, (String)description, listener2);
    }

    @Deprecated
    public static void executeConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (project2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(9);
        }
        ProgramRunnerUtil.executeConfiguration(configuration, executor);
    }

    public static void executeConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder;
        if (configuration == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(11);
        }
        try {
            builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    public static Icon getConfigurationIcon(RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon2 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    @NotNull
    public static Icon getRawIcon(RunnerAndConfigurationSettings settings) {
        Icon icon;
        RunConfiguration configuration = settings.getConfiguration();
        ConfigurationFactory factory = settings.getFactory();
        Icon icon2 = icon = factory != null ? factory.getIcon(configuration) : null;
        if (icon == null) {
            icon = AllIcons.RunConfigurations.Unknown;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(12);
        }
        return icon3;
    }

    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        if (rawIcon == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(13);
        }
        return IconLoader.getTransparentIcon((Icon)rawIcon, (float)0.3f);
    }

    public static String shortenName(@Nullable String name2, int toBeAdded) {
        if (name2 == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        return name2.length() < symbols + 3 ? name2 : name2.substring(0, symbols) + "...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ProgramRunnerUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ProgramRunnerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRunOnErrorMessage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCannotRunOnErrorMessage";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeConfigurationAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleExecutionError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTemporaryIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

