/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    public static final Icon CHECKED_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(AllIcons.Actions.Checked, 16, 16));
    public static final Icon CHECKED_SELECTED_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16));
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
        }
        try {
            if (project2 == null || project2.isDisposed() || !project2.isOpen()) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation);
                presentation.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)project2), RunManager.getInstance((Project)project2).getSelectedConfiguration(), project2, presentation);
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updatePresentation(@Nullable ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project2, @NotNull Presentation presentation) {
        if (presentation == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(0);
        }
        if (project2 != null && target2 != null && settings != null) {
            String name2 = Executor.shortenNameIfNeed((String)settings.getName());
            if (target2 != DefaultExecutionTarget.INSTANCE) {
                name2 = name2 + " | " + target2.getDisplayName();
            } else if (!ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)settings, (ExecutionTarget)target2)) {
                name2 = name2 + " | Nothing to run on";
            }
            presentation.setText(name2, false);
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project2);
        } else {
            presentation.setText("");
            presentation.setIcon(null);
        }
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project2) {
        try {
            Icon icon = RunManagerEx.getInstanceEx(project2).getConfigurationIcon(settings);
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project2);
            List<RunContentDescriptor> runningDescriptors2 = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)s -> s == settings));
            if (runningDescriptors2.size() == 1) {
                icon = ExecutionUtil.getLiveIndicator((Icon)icon);
            }
            if (runningDescriptors2.size() > 1) {
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(runningDescriptors2.size()));
            }
            presentation.setIcon(icon);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ComboBoxAction.ComboBoxButton button = new ComboBoxAction.ComboBoxButton(presentation){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, JBUI.scale((int)75));
                return d;
            }
        };
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        panel2.add((Component)button);
        return panel2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        if (project2 != null) {
            allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
            allActionsGroup.add((AnAction)new SaveTemporaryAction());
            allActionsGroup.addSeparator();
            RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)project2).getSelectedConfiguration();
            if (selected != null) {
                ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project2);
                for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project2, (RunnerAndConfigurationSettings)selected)) {
                    allActionsGroup.add((AnAction)new SelectTargetAction(project2, eachTarget, eachTarget.equals((Object)activeTarget)));
                }
                allActionsGroup.addSeparator();
            }
            RunManagerEx runManager = RunManagerEx.getInstanceEx(project2);
            for (ConfigurationType type2 : runManager.getConfigurationFactories()) {
                DefaultActionGroup actionGroup = new DefaultActionGroup();
                Map<String, List<RunnerAndConfigurationSettings>> structure = runManager.getStructure(type2);
                for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                    DefaultActionGroup group = entry.getKey() != null ? new DefaultActionGroup(entry.getKey(), true) : actionGroup;
                    group.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                    for (RunnerAndConfigurationSettings settings : entry.getValue()) {
                        group.add((AnAction)new SelectConfigAction(settings, project2));
                    }
                    if (group == actionGroup) continue;
                    actionGroup.add((AnAction)group);
                }
                allActionsGroup.add((AnAction)actionGroup);
                allActionsGroup.addSeparator();
            }
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectConfigAction
    extends DumbAwareAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        public SelectConfigAction(RunnerAndConfigurationSettings configuration, Project project2) {
            this.myConfiguration = configuration;
            this.myProject = project2;
            String name2 = Executor.shortenNameIfNeed((String)configuration.getName());
            if (name2.isEmpty()) {
                name2 = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name2, false);
            presentation.setDescription("Select " + configuration.getType().getConfigurationTypeDescription() + " '" + name2 + "'");
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(AnActionEvent e) {
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            this.updateIcon(e.getPresentation());
        }
    }

    private static class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        public SelectTargetAction(Project project2, ExecutionTarget target2, boolean selected) {
            this.myProject = project2;
            this.myTarget = target2;
            String name2 = target2.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name2, false);
            presentation.setDescription("Select " + name2);
            presentation.setIcon(selected ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation());
        }

        public boolean isDumbAware() {
            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            return configuration == null || configuration.getType().isDumbAware();
        }
    }

    private static class SaveTemporaryAction
    extends DumbAwareAction {
        public SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.RunConfigurations.SaveTempConfig);
        }

        public void actionPerformed(AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 != null && (settings = SaveTemporaryAction.chooseTempSettings(project2)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project2);
                runManager.makeStable(settings);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project2);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.message((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{Executor.shortenNameIfNeed((String)settings.getName())}));
                presentation.setDescription(presentation.getText());
                presentation.setVisible(true);
                presentation.setEnabled(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project2) {
            RunnerAndConfigurationSettings selectedConfiguration;
            if (project2 == null) {
                SaveTemporaryAction.$$$reportNull$$$0(0);
            }
            if ((selectedConfiguration = RunManager.getInstance((Project)project2).getSelectedConfiguration()) != null && selectedConfiguration.isTemporary()) {
                return selectedConfiguration;
            }
            return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)RunManager.getInstance((Project)project2).getTempConfigurationsList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction", "chooseTempSettings"));
        }
    }
}

