/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EditableModel;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeModel
extends DefaultTreeModel
implements EditableModel,
RowsDnDSupport.RefinedDropSupport {
    private final Project myProject;
    private final Tree myTree;

    public RunDashboardTreeModel(TreeNode root, @NotNull Project project2, @NotNull Tree tree) {
        if (project2 == null) {
            RunDashboardTreeModel.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            RunDashboardTreeModel.$$$reportNull$$$0(1);
        }
        super(root);
        this.myProject = project2;
        this.myTree = tree;
    }

    public void addRow() {
    }

    public void exchangeRows(int oldIndex, int newIndex) {
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public void removeRow(int idx) {
    }

    public boolean isDropInto(JComponent component, int oldIndex, int newIndex) {
        if (this.myProject.isDisposed() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            return false;
        }
        RunDashboardRunConfigurationNode oldNode = this.getRunConfigurationNode(oldIndex);
        if (oldNode == null) {
            return false;
        }
        GroupingNode newNode = this.getGroupingNode(newIndex);
        return newNode != null && newNode.getGroup() instanceof FolderDashboardGroupingRule.FolderDashboardGroup;
    }

    public boolean canDrop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
        if (position == null) {
            RunDashboardTreeModel.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            return false;
        }
        RunDashboardRunConfigurationNode oldNode = this.getRunConfigurationNode(oldIndex);
        if (oldNode == null) {
            return false;
        }
        if (position == RowsDnDSupport.RefinedDropSupport.Position.INTO) {
            GroupingNode newNode = this.getGroupingNode(newIndex);
            return newNode != null && newNode.getGroup() instanceof FolderDashboardGroupingRule.FolderDashboardGroup;
        }
        return this.getRunConfigurationNode(newIndex) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
        if (position == null) {
            RunDashboardTreeModel.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            return;
        }
        RunDashboardRunConfigurationNode oldNode = this.getRunConfigurationNode(oldIndex);
        if (oldNode == null) {
            return;
        }
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        runManager.fireBeginUpdate();
        try {
            if (position == RowsDnDSupport.RefinedDropSupport.Position.INTO) {
                GroupingNode newNode = this.getGroupingNode(newIndex);
                if (newNode == null || !(newNode.getGroup() instanceof FolderDashboardGroupingRule.FolderDashboardGroup)) {
                    return;
                }
                oldNode.getConfigurationSettings().setFolderName(newNode.getGroup().getName());
                return;
            }
            RunDashboardRunConfigurationNode newNode = this.getRunConfigurationNode(newIndex);
            if (newNode == null) {
                return;
            }
            oldNode.getConfigurationSettings().setFolderName(newNode.getConfigurationSettings().getFolderName());
            TObjectIntHashMap indices2 = new TObjectIntHashMap();
            int i = 0;
            for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
                if (each.equals(oldNode.getConfigurationSettings())) continue;
                if (each.equals(newNode.getConfigurationSettings())) {
                    if (position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                        indices2.put((Object)oldNode.getConfigurationSettings(), i++);
                        indices2.put((Object)newNode.getConfigurationSettings(), i++);
                        continue;
                    }
                    if (position != RowsDnDSupport.RefinedDropSupport.Position.BELOW) continue;
                    indices2.put((Object)newNode.getConfigurationSettings(), i++);
                    indices2.put((Object)oldNode.getConfigurationSettings(), i++);
                    continue;
                }
                indices2.put((Object)each, i++);
            }
            runManager.setOrder(Comparator.comparingInt(arg_0 -> ((TObjectIntHashMap)indices2).get(arg_0)));
        }
        finally {
            runManager.fireEndUpdate();
        }
    }

    @Nullable
    private RunDashboardRunConfigurationNode getRunConfigurationNode(int index) {
        return this.getDashboardNode(index, RunDashboardRunConfigurationNode.class);
    }

    @Nullable
    private GroupingNode getGroupingNode(int index) {
        return this.getDashboardNode(index, GroupingNode.class);
    }

    @Nullable
    <T> T getDashboardNode(int index, Class<T> nodeClass) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myTree.getPathForRow(index).getLastPathComponent();
        return (T)ObjectUtils.tryCast((Object)treeNode.getUserObject(), nodeClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/tree/RunDashboardTreeModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canDrop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "drop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

