/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternBasedFileHyperlinkRawDataFinder
implements FileHyperlinkRawDataFinder {
    private static final int UNKNOWN = -2;
    private final PatternHyperlinkFormat[] myLinkFormats;

    public PatternBasedFileHyperlinkRawDataFinder(@NotNull PatternHyperlinkFormat[] linkFormats) {
        if (linkFormats == null) {
            PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(0);
        }
        this.myLinkFormats = linkFormats;
    }

    @Override
    @NotNull
    public List<FileHyperlinkRawData> find(@NotNull String line) {
        Pair<Matcher, PatternHyperlinkFormat> pair2;
        if (line == null) {
            PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(1);
        }
        if ((pair2 = this.findMatcher(line)) == null) {
            List<FileHyperlinkRawData> list2 = Collections.emptyList();
            if (list2 == null) {
                PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Matcher matcher = (Matcher)pair2.first;
        PatternHyperlinkFormat format = (PatternHyperlinkFormat)pair2.second;
        PatternHyperlinkPart[] linkParts = format.getLinkParts();
        int groupCount = matcher.groupCount();
        if (groupCount > linkParts.length) {
            List<FileHyperlinkRawData> list3 = Collections.emptyList();
            if (list3 == null) {
                PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(3);
            }
            return list3;
        }
        String path = null;
        int lineNumber = -1;
        int columnNumber = -1;
        int hyperlinkStartInd = -1;
        int hyperlinkEndInd = -1;
        boolean hyperlinkFreezed = false;
        for (int i = 1; i <= groupCount; ++i) {
            String value2 = matcher.group(i);
            if (value2 == null) continue;
            PatternHyperlinkPart part = linkParts[i - 1];
            if (part == PatternHyperlinkPart.HYPERLINK) {
                hyperlinkStartInd = matcher.start(i);
                hyperlinkEndInd = matcher.end(i);
                hyperlinkFreezed = true;
                continue;
            }
            if (part == PatternHyperlinkPart.PATH) {
                path = value2;
                if (hyperlinkFreezed) continue;
                hyperlinkStartInd = matcher.start(i);
                hyperlinkEndInd = matcher.end(i);
                continue;
            }
            if (part == PatternHyperlinkPart.LINE) {
                value2 = StringUtil.trimStart((String)value2, (String)":");
                lineNumber = StringUtil.parseInt((String)value2, (int)-2);
                hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i), matcher.end(i));
                continue;
            }
            if (part != PatternHyperlinkPart.COLUMN || (columnNumber = StringUtil.parseInt((String)(value2 = StringUtil.trimStart((String)value2, (String)":")), (int)-2)) == -2) continue;
            hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i), matcher.end(i));
        }
        if (path == null || lineNumber == -2 || columnNumber == -2 || hyperlinkStartInd == -1) {
            List<FileHyperlinkRawData> list4 = Collections.emptyList();
            if (list4 == null) {
                PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(4);
            }
            return list4;
        }
        if (!format.isZeroBasedLineNumbering()) {
            --lineNumber;
        }
        if (!format.isZeroBasedColumnNumbering()) {
            --columnNumber;
        }
        lineNumber = Math.max(lineNumber, -1);
        columnNumber = Math.max(columnNumber, -1);
        FileHyperlinkRawData data = new FileHyperlinkRawData(path, lineNumber, columnNumber, hyperlinkStartInd, hyperlinkEndInd);
        List<FileHyperlinkRawData> list5 = Collections.singletonList(data);
        if (list5 == null) {
            PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(5);
        }
        return list5;
    }

    private static int tryExtendHyperlinkEnd(boolean hyperlinkFreezed, int hyperlinkEndInd, int groupStartInd, int groupEndInd) {
        if (!(hyperlinkFreezed || hyperlinkEndInd != groupStartInd && hyperlinkEndInd + 1 != groupStartInd)) {
            return groupEndInd;
        }
        return hyperlinkEndInd;
    }

    @Nullable
    private Pair<Matcher, PatternHyperlinkFormat> findMatcher(@NotNull String line) {
        if (line == null) {
            PatternBasedFileHyperlinkRawDataFinder.$$$reportNull$$$0(6);
        }
        for (PatternHyperlinkFormat linkFormat : this.myLinkFormats) {
            Matcher matcher = linkFormat.getPattern().matcher(line);
            if (!matcher.find()) continue;
            return Pair.create((Object)matcher, (Object)linkFormat);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkFormats";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

