/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T>
implements Cloneable {
    public AbstractPatternBasedConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        LinkedHashSet<String> classes2 = new LinkedHashSet<String>();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return false;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes2, dataContext);
        if (locationElements == null) {
            this.collectContextElements(dataContext, true, false, classes2, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        if (Comparing.equal(classes2, patterns)) {
            String pattern;
            if (patterns.size() == 1 && !(pattern = patterns.iterator().next()).contains(",")) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), PsiMethod.class);
                return method != null && this.isTestMethod(false, method);
            }
            return true;
        }
        return false;
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes2) {
        PsiElement[] result2;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return null;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes2, dataContext);
        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, true, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
            result2 = processor2.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes2, (PsiElementProcessor.CollectElements<PsiElement>)processor2)) {
            result2 = processor2.toArray();
        } else {
            return null;
        }
        if (result2.length <= 1) {
            return null;
        }
        return result2[0];
    }
}

