/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements SMTestLocator,
DumbAware {
    public static final FileUrlProvider INSTANCE = new FileUrlProvider();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        int columnNumber;
        int lineNumber;
        String filePath;
        if (protocol == null) {
            FileUrlProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileUrlProvider.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            FileUrlProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            FileUrlProvider.$$$reportNull$$$0(3);
        }
        if (!"file".equals(protocol)) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                FileUrlProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        int lastColonIndex = path.lastIndexOf(58);
        if (lastColonIndex > 3) {
            int lastValue = StringUtil.parseInt((String)path.substring(lastColonIndex + 1), (int)-1);
            int penultimateColonIndex = path.lastIndexOf(58, lastColonIndex - 1);
            if (penultimateColonIndex > 3) {
                int penultimateValue = StringUtil.parseInt((String)path.substring(penultimateColonIndex + 1, lastColonIndex), (int)-1);
                filePath = path.substring(0, penultimateColonIndex);
                lineNumber = penultimateValue;
                columnNumber = lineNumber <= 0 ? -1 : lastValue;
            } else {
                filePath = path.substring(0, lastColonIndex);
                lineNumber = lastValue;
                columnNumber = -1;
            }
        } else {
            filePath = path;
            lineNumber = -1;
            columnNumber = -1;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project2);
        if (virtualFiles.isEmpty()) {
            List<Location> list3 = Collections.emptyList();
            if (list3 == null) {
                FileUrlProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file2 : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project2, file2, lineNumber, columnNumber));
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            FileUrlProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project2, @NotNull VirtualFile virtualFile, int lineNum) {
        if (project2 == null) {
            FileUrlProvider.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            FileUrlProvider.$$$reportNull$$$0(8);
        }
        return FileUrlProvider.createLocationFor(project2, virtualFile, lineNum, -1);
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project2, @NotNull VirtualFile virtualFile, int lineNum, int columnNum) {
        int length;
        PsiFile psiFile;
        if (project2 == null) {
            FileUrlProvider.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            FileUrlProvider.$$$reportNull$$$0(10);
        }
        if ((psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile)) == null) {
            return null;
        }
        if (lineNum <= 0) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (lineNum > doc.getLineCount()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        int lineStartOffset = doc.getLineStartOffset(lineNum - 1);
        int endOffset = doc.getLineEndOffset(lineNum - 1);
        PsiElement elementAtLine = null;
        for (int offset = Math.min(lineStartOffset + Math.max(columnNum - 1, 0), endOffset); offset <= endOffset && (elementAtLine = psiFile.findElementAt(offset)) instanceof PsiWhiteSpace; offset += (length = elementAtLine.getTextLength()) > 1 ? length - 1 : 1) {
        }
        return PsiLocation.fromPsiElement((Project)project2, (PsiElement)(elementAtLine != null ? elementAtLine : psiFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/FileUrlProvider";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/FileUrlProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLocationFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

