/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeRegistryImpl
extends FacetTypeRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetTypeRegistryImpl");
    private static final Comparator<FacetType> FACET_TYPE_COMPARATOR = (o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
    private final Map<String, FacetTypeId> myTypeIds = new HashMap<String, FacetTypeId>();
    private final Map<FacetTypeId, FacetType> myFacetTypes = new HashMap<FacetTypeId, FacetType>();
    private boolean myExtensionsLoaded = false;

    public synchronized void registerFacetType(FacetType facetType) {
        FacetTypeId typeId = facetType.getId();
        String id = facetType.getStringId();
        LOG.assertTrue(!id.contains("/"), (Object)("Facet type id '" + id + "' contains illegal character '/'"));
        LOG.assertTrue(!this.myFacetTypes.containsKey(typeId), (Object)("Facet type '" + id + "' is already registered"));
        this.myFacetTypes.put(typeId, facetType);
        LOG.assertTrue(!this.myTypeIds.containsKey(id), (Object)("Facet type id '" + id + "' is already registered"));
        this.myTypeIds.put(id, typeId);
    }

    public synchronized void unregisterFacetType(FacetType facetType) {
        FacetTypeId id = facetType.getId();
        String stringId = facetType.getStringId();
        LOG.assertTrue(this.myFacetTypes.remove(id) != null, (Object)("Facet type '" + stringId + "' is not registered"));
        this.myFacetTypes.remove(id);
        this.myTypeIds.remove(stringId);
    }

    @NotNull
    public synchronized FacetTypeId[] getFacetTypeIds() {
        this.loadExtensions();
        Set<FacetTypeId> ids = this.myFacetTypes.keySet();
        FacetTypeId[] facetTypeIdArray = ids.toArray(new FacetTypeId[ids.size()]);
        if (facetTypeIdArray == null) {
            FacetTypeRegistryImpl.$$$reportNull$$$0(0);
        }
        return facetTypeIdArray;
    }

    @NotNull
    public synchronized FacetType[] getFacetTypes() {
        this.loadExtensions();
        Collection<FacetType> types = this.myFacetTypes.values();
        FacetType[] facetTypes = types.toArray(new FacetType[types.size()]);
        Arrays.sort(facetTypes, FACET_TYPE_COMPARATOR);
        if (facetTypes == null) {
            FacetTypeRegistryImpl.$$$reportNull$$$0(1);
        }
        return facetTypes;
    }

    @NotNull
    public FacetType[] getSortedFacetTypes() {
        FacetType[] types = this.getFacetTypes();
        Arrays.sort(types, FACET_TYPE_COMPARATOR);
        if (types == null) {
            FacetTypeRegistryImpl.$$$reportNull$$$0(2);
        }
        return types;
    }

    @Nullable
    public synchronized FacetType findFacetType(String id) {
        this.loadExtensions();
        FacetTypeId typeId = this.myTypeIds.get(id);
        return typeId == null ? null : this.myFacetTypes.get(typeId);
    }

    @NotNull
    public synchronized <F extends Facet<C>, C extends FacetConfiguration> FacetType<F, C> findFacetType(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            FacetTypeRegistryImpl.$$$reportNull$$$0(3);
        }
        this.loadExtensions();
        FacetType type2 = this.myFacetTypes.get(typeId);
        LOG.assertTrue(type2 != null, (Object)("Cannot find facet by id '" + typeId + "'"));
        FacetType facetType = type2;
        if (facetType == null) {
            FacetTypeRegistryImpl.$$$reportNull$$$0(4);
        }
        return facetType;
    }

    private void loadExtensions() {
        if (!this.myExtensionsLoaded) {
            this.myExtensionsLoaded = true;
            ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(FacetType.EP_NAME);
            extensionPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetType>(){

                public void extensionAdded(@NotNull FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FacetTypeRegistryImpl.this.registerFacetType(extension);
                }

                public void extensionRemoved(@NotNull FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    FacetTypeRegistryImpl.this.unregisterFacetType(extension);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "extension";
                    objectArray2[1] = "com/intellij/facet/impl/FacetTypeRegistryImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetTypeRegistryImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetTypeIds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacetTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetTypeRegistryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFacetType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFacetType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

