/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompositionSettings
implements Disposable {
    private final CustomLibraryDescription myLibraryDescription;
    @NotNull
    private final NotNullComputable<String> myPathProvider;
    private FrameworkLibraryVersionFilter myVersionFilter;
    private final List<? extends FrameworkLibraryVersion> myAllVersions;
    private LibrariesContainer.LibraryLevel myNewLibraryLevel;
    private NewLibraryEditor myNewLibraryEditor;
    private Library mySelectedLibrary;
    private boolean myDownloadLibraries;
    private LibraryDownloadSettings myDownloadSettings;
    private Map<Library, ExistingLibraryEditor> myExistingLibraryEditors;
    private FrameworkLibraryProvider myLibraryProvider;

    public LibraryCompositionSettings(@NotNull CustomLibraryDescription libraryDescription, @NotNull NotNullComputable<String> pathProvider, @NotNull FrameworkLibraryVersionFilter versionFilter, List<? extends FrameworkLibraryVersion> allVersions) {
        if (libraryDescription == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(0);
        }
        if (pathProvider == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(1);
        }
        if (versionFilter == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(2);
        }
        this.myExistingLibraryEditors = ContainerUtil.newIdentityTroveMap();
        this.myLibraryDescription = libraryDescription;
        this.myPathProvider = pathProvider;
        this.myVersionFilter = versionFilter;
        this.myNewLibraryLevel = libraryDescription.getDefaultLevel();
        this.myAllVersions = allVersions;
        List<? extends FrameworkLibraryVersion> versions = this.getCompatibleVersions();
        if (!versions.isEmpty()) {
            this.myDownloadSettings = this.createDownloadSettings(versions.get(0));
        }
    }

    private LibraryDownloadSettings createDownloadSettings(FrameworkLibraryVersion version) {
        return new LibraryDownloadSettings(version, this.myLibraryDescription.getDownloadableLibraryType(), this.myNewLibraryLevel, LibraryCompositionSettings.getDefaultDownloadPath(this.getBaseDirectoryPath()));
    }

    public void setVersionFilter(@NotNull FrameworkLibraryVersionFilter versionFilter) {
        if (versionFilter == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(3);
        }
        this.myVersionFilter = versionFilter;
        if (this.myDownloadSettings == null || !versionFilter.isAccepted(this.myDownloadSettings.getVersion())) {
            FrameworkLibraryVersion newLibraryVersion = (FrameworkLibraryVersion)ContainerUtil.getFirstItem(this.getCompatibleVersions());
            this.myDownloadSettings = newLibraryVersion != null ? this.createDownloadSettings(newLibraryVersion) : null;
        }
    }

    public List<? extends FrameworkLibraryVersion> getCompatibleVersions() {
        ArrayList<FrameworkLibraryVersion> result2 = new ArrayList<FrameworkLibraryVersion>();
        for (FrameworkLibraryVersion frameworkLibraryVersion : this.myAllVersions) {
            if (!this.myVersionFilter.isAccepted(frameworkLibraryVersion)) continue;
            result2.add(frameworkLibraryVersion);
        }
        return result2;
    }

    private static String getDefaultDownloadPath(@NotNull String baseDirectoryPath) {
        if (baseDirectoryPath == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(4);
        }
        return baseDirectoryPath.isEmpty() ? "lib" : baseDirectoryPath + "/lib";
    }

    public void setDownloadSettings(LibraryDownloadSettings downloadSettings) {
        this.myDownloadSettings = downloadSettings;
    }

    public ExistingLibraryEditor getOrCreateEditor(@NotNull Library library) {
        ExistingLibraryEditor libraryEditor;
        if (library == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(5);
        }
        if ((libraryEditor = this.myExistingLibraryEditors.get(library)) == null) {
            libraryEditor = new ExistingLibraryEditor(library, null);
            Disposer.register((Disposable)this, (Disposable)libraryEditor);
            this.myExistingLibraryEditors.put(library, libraryEditor);
        }
        return libraryEditor;
    }

    @NotNull
    public CustomLibraryDescription getLibraryDescription() {
        CustomLibraryDescription customLibraryDescription = this.myLibraryDescription;
        if (customLibraryDescription == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(6);
        }
        return customLibraryDescription;
    }

    @Nullable
    public LibraryDownloadSettings getDownloadSettings() {
        return this.myDownloadSettings;
    }

    @NotNull
    public String getBaseDirectoryPath() {
        String string = (String)this.myPathProvider.compute();
        if (string == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setDownloadLibraries(boolean downloadLibraries) {
        this.myDownloadLibraries = downloadLibraries;
    }

    public void setSelectedExistingLibrary(@Nullable Library library) {
        this.mySelectedLibrary = library;
    }

    public void setNewLibraryLevel(LibrariesContainer.LibraryLevel newLibraryLevel) {
        this.myNewLibraryLevel = newLibraryLevel;
    }

    public boolean downloadFiles(@NotNull JComponent parent) {
        NewLibraryEditor libraryEditor;
        if (parent == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(8);
        }
        if (this.myDownloadLibraries && this.myDownloadSettings != null && (libraryEditor = this.myDownloadSettings.download(parent, this.getBaseDirectoryPath())) != null) {
            this.myNewLibraryEditor = libraryEditor;
        }
        return true;
    }

    public boolean isLibraryConfigured() {
        return this.myDownloadLibraries || this.myNewLibraryEditor != null || this.mySelectedLibrary != null || this.myLibraryProvider != null;
    }

    @Nullable
    private Library createLibrary(ModifiableRootModel rootModel, @Nullable LibrariesContainer additionalContainer) {
        if (this.myNewLibraryEditor != null) {
            return LibrariesContainerFactory.createLibrary(additionalContainer, LibrariesContainerFactory.createContainer(rootModel), this.myNewLibraryEditor, this.getLibraryLevel());
        }
        return null;
    }

    private LibrariesContainer.LibraryLevel getLibraryLevel() {
        return this.myDownloadLibraries ? this.myDownloadSettings.getLibraryLevel() : this.myNewLibraryLevel;
    }

    public LibrariesContainer.LibraryLevel getNewLibraryLevel() {
        return this.myNewLibraryLevel;
    }

    @Nullable
    public Library addLibraries(@NotNull ModifiableRootModel rootModel, @NotNull List<Library> addedLibraries, @Nullable LibrariesContainer librariesContainer) {
        Library newLibrary;
        if (rootModel == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(9);
        }
        if (addedLibraries == null) {
            LibraryCompositionSettings.$$$reportNull$$$0(10);
        }
        if ((newLibrary = this.createLibrary(rootModel, librariesContainer)) != null) {
            addedLibraries.add(newLibrary);
            DependencyScope scope = LibraryDependencyScopeSuggester.getDefaultScope(newLibrary);
            if (this.getLibraryLevel() != LibrariesContainer.LibraryLevel.MODULE) {
                rootModel.addLibraryEntry(newLibrary).setScope(scope);
            } else {
                LibraryOrderEntry orderEntry = rootModel.findLibraryOrderEntry(newLibrary);
                assert (orderEntry != null);
                orderEntry.setScope(scope);
            }
        }
        if (this.mySelectedLibrary != null) {
            addedLibraries.add(this.mySelectedLibrary);
            rootModel.addLibraryEntry(this.mySelectedLibrary).setScope(LibraryDependencyScopeSuggester.getDefaultScope(this.mySelectedLibrary));
        }
        if (this.myLibraryProvider != null) {
            Library library = this.myLibraryProvider.createLibrary(this.myLibraryDescription.getSuitableLibraryKinds());
            addedLibraries.add(library);
            rootModel.addLibraryEntry(library).setScope(LibraryDependencyScopeSuggester.getDefaultScope(library));
        }
        return newLibrary;
    }

    public void setNewLibraryEditor(@Nullable NewLibraryEditor libraryEditor) {
        this.myNewLibraryEditor = libraryEditor;
    }

    public void setLibraryProvider(FrameworkLibraryProvider libraryProvider) {
        this.myLibraryProvider = libraryProvider;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectoryPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectoryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVersionFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDownloadPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEditor";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

