/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFilePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JavaFilePasteProvider.$$$reportNull$$$0(0);
        }
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || ideView == null) {
            return;
        }
        final PsiJavaFile javaFile = JavaFilePasteProvider.createJavaFileFromClipboardContent(project2);
        if (javaFile == null) {
            return;
        }
        PsiClass[] classes2 = javaFile.getClasses();
        if (classes2.length < 1) {
            return;
        }
        final PsiDirectory targetDir = ideView.getOrChooseDirectory();
        if (targetDir == null) {
            return;
        }
        PsiClass publicClass = classes2[0];
        for (PsiClass aClass : classes2) {
            if (!aClass.hasModifierProperty("public")) continue;
            publicClass = aClass;
            break;
        }
        final PsiClass mainClass = publicClass;
        new WriteCommandAction(project2, "Paste class '" + mainClass.getName() + "'", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiFile file2;
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    file2 = targetDir.createFile(mainClass.getName() + ".java");
                }
                catch (IncorrectOperationException e) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
                if (document != null) {
                    document.setText((CharSequence)javaFile.getText());
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                }
                if (file2 instanceof PsiJavaFile) {
                    JavaFilePasteProvider.updatePackageStatement((PsiJavaFile)file2, targetDir);
                }
                new OpenFileDescriptor(project2, file2.getVirtualFile()).navigate(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/JavaFilePasteProvider$1", "run"));
            }
        }.execute();
    }

    private static void updatePackageStatement(PsiJavaFile javaFile, PsiDirectory targetDir) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDir);
        if (aPackage == null) {
            return;
        }
        PsiPackageStatement oldStatement = javaFile.getPackageStatement();
        Project project2 = javaFile.getProject();
        if (oldStatement != null && !oldStatement.getPackageName().equals(aPackage.getQualifiedName()) || oldStatement == null && aPackage.getQualifiedName().length() > 0) {
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                try {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                    PsiPackageStatement newStatement = factory.createPackageStatement(aPackage.getQualifiedName());
                    if (oldStatement != null) {
                        oldStatement.replace((PsiElement)newStatement);
                    } else {
                        PsiElement addedStatement = javaFile.addAfter((PsiElement)newStatement, null);
                        TextRange textRange = addedStatement.getTextRange();
                        CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)javaFile, textRange.getStartOffset(), textRange.getEndOffset() + 1);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }, "Updating package statement", null);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JavaFilePasteProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JavaFilePasteProvider.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || ideView == null || ideView.getDirectories().length == 0) {
            return false;
        }
        PsiJavaFile file2 = JavaFilePasteProvider.createJavaFileFromClipboardContent(project2);
        return file2 != null && file2.getClasses().length >= 1;
    }

    @Nullable
    private static PsiJavaFile createJavaFileFromClipboardContent(Project project2) {
        String text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (text2 == null) {
            return null;
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("A.java", (Language)JavaLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)text2));
        return psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/ide/JavaFilePasteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

