/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.ElementBase;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ui.update.ComparableObject;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeIconProvider
extends IconProvider
implements DumbAware {
    private final Map<Ext, Icon> myIconCache = new HashMap<Ext, Icon>();
    private final Set<Ext> myCustomIconExtensions = SystemInfo.isWindows ? new HashSet<Ext>(Arrays.asList(new Ext("exe"), new Ext("ico"))) : new HashSet();
    private final Map<String, Icon> myCustomIconCache = new HashMap<String, Icon>();
    private static final Ext NO_EXT = new Ext(null);
    private static final Ext CLOSED_DIR = new Ext(null, 0);

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        VirtualFile file2;
        if (element == null) {
            NativeIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiFileSystemItem && (file2 = ((PsiFileSystemItem)element).getVirtualFile()) != null) {
            return this.doGetIcon(file2, flags);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Icon doGetIcon(@NotNull VirtualFile file2, int flags) {
        Icon icon;
        if (file2 == null) {
            NativeIconProvider.$$$reportNull$$$0(1);
        }
        if (!this.isNativeFileType(file2)) {
            return null;
        }
        Ext ext = NativeIconProvider.getExtension(file2, flags);
        String filePath = file2.getPath();
        Map<Ext, Icon> map = this.myIconCache;
        synchronized (map) {
            icon = !this.myCustomIconExtensions.contains((Object)ext) ? (ext != null ? this.myIconCache.get((Object)ext) : null) : (filePath != null ? this.myCustomIconCache.get(filePath) : null);
        }
        if (icon != null) {
            return icon;
        }
        return new DeferredIconImpl<VirtualFile>((Icon)ElementBase.ICON_PLACEHOLDER.getValue(), file2, false, virtualFile -> {
            Icon icon1;
            File f = new File(filePath);
            if (!f.exists()) {
                return null;
            }
            try {
                assert (SwingComponentHolder.ourFileChooser != null || !ApplicationManager.getApplication().isReadAccessAllowed());
                icon1 = NativeIconProvider.getNativeIcon(f);
            }
            catch (Exception e) {
                return null;
            }
            if (ext != null) {
                Map<Ext, Icon> map = this.myIconCache;
                synchronized (map) {
                    if (!this.myCustomIconExtensions.contains((Object)ext)) {
                        this.myIconCache.put(ext, icon1);
                    } else if (filePath != null) {
                        this.myCustomIconCache.put(filePath, icon1);
                    }
                }
            }
            return icon1;
        });
    }

    @Nullable
    public static Icon getNativeIcon(@Nullable File file2) {
        return file2 == null ? null : SwingComponentHolder.ourFileChooser.getIcon(file2);
    }

    private static Ext getExtension(VirtualFile file2, int flags) {
        if (file2.isDirectory()) {
            if (file2.getExtension() == null) {
                return CLOSED_DIR;
            }
            return new Ext(file2.getExtension(), flags);
        }
        return file2.getExtension() != null ? new Ext(file2.getExtension()) : NO_EXT;
    }

    protected boolean isNativeFileType(VirtualFile file2) {
        FileType type2 = file2.getFileType();
        if (type2 instanceof INativeFileType) {
            return ((INativeFileType)type2).useNativeIcon();
        }
        return type2 instanceof UnknownFileType && !file2.isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/NativeIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Ext
    extends ComparableObject.Impl {
        private final Object[] myText;

        private Ext(@Nullable String text2) {
            this.myText = new Object[]{text2};
        }

        private Ext(@Nullable String text2, int flags) {
            this.myText = new Object[]{text2, flags};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.myText == null) {
                Ext.$$$reportNull$$$0(0);
            }
            return this.myText;
        }

        public String toString() {
            return this.myText[0] != null ? this.myText[0].toString() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/NativeIconProvider$Ext", "getEqualityObjects"));
        }
    }

    static class SwingComponentHolder {
        private static final JFileChooser ourFileChooser = new JFileChooser();

        SwingComponentHolder() {
        }
    }
}

