/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TypeIconEP;
import com.intellij.ide.TypeNameEP;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class TypePresentationServiceImpl
extends TypePresentationService {
    private static final ExtensionPointName<PresentationProvider> PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.presentationProvider");
    private static final ClassExtension<PresentationProvider> PROVIDERS = new ClassExtension(PROVIDER_EP.getName());
    private final Map<String, NullableLazyValue<Icon>> myIcons = new HashMap<String, NullableLazyValue<Icon>>();
    private final Map<String, NullableLazyValue<String>> myNames = new HashMap<String, NullableLazyValue<String>>();
    private final Map<Class, Set<PresentationTemplate>> mySuperClasses = ConcurrentFactoryMap.createMap(key2 -> {
        LinkedHashSet<PresentationTemplate> templates = new LinkedHashSet<PresentationTemplate>();
        this.walkSupers((Class)key2, (Set<Class>)new LinkedHashSet<Class>(), (Set<PresentationTemplate>)templates);
        return templates;
    });

    public Icon getIcon(Object o) {
        return this.getIcon(o.getClass(), o);
    }

    @Nullable
    public Icon getTypeIcon(Class type2) {
        return this.getIcon(type2, null);
    }

    private Icon getIcon(Class type2, Object o) {
        Set<PresentationTemplate> templates = this.mySuperClasses.get(type2);
        for (PresentationTemplate template : templates) {
            Icon icon = template.getIcon(o, 0);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @Nullable
    public String getTypePresentableName(Class type2) {
        Set<PresentationTemplate> templates = this.mySuperClasses.get(type2);
        for (PresentationTemplate template : templates) {
            String typeName = template.getTypeName();
            if (typeName == null) continue;
            return typeName;
        }
        return TypePresentationServiceImpl.getDefaultTypeName((Class)type2);
    }

    public String getTypeName(Object o) {
        Set<PresentationTemplate> templates = this.mySuperClasses.get(o.getClass());
        for (PresentationTemplate template : templates) {
            String typeName = template.getTypeName(o);
            if (typeName == null) continue;
            return typeName;
        }
        return null;
    }

    public TypePresentationServiceImpl() {
        for (TypeIconEP typeIconEP : (TypeIconEP[])Extensions.getExtensions((ExtensionPointName)TypeIconEP.EP_NAME)) {
            this.myIcons.put(typeIconEP.className, (NullableLazyValue<Icon>)typeIconEP.getIcon());
        }
        for (TypeIconEP typeIconEP : (TypeNameEP[])Extensions.getExtensions((ExtensionPointName)TypeNameEP.EP_NAME)) {
            this.myNames.put(typeIconEP.className, (NullableLazyValue<String>)typeIconEP.getTypeName());
        }
    }

    @Nullable
    private PresentationTemplate createPresentationTemplate(Class<?> type2) {
        Presentation presentation = type2.getAnnotation(Presentation.class);
        if (presentation != null) {
            return new AnnotationBasedTemplate(presentation, type2);
        }
        PresentationProvider provider = (PresentationProvider)PROVIDERS.forClass(type2);
        if (provider != null) {
            return new ProviderBasedTemplate(provider);
        }
        final NullableLazyValue<Icon> icon = this.myIcons.get(type2.getName());
        final NullableLazyValue<String> typeName = this.myNames.get(type2.getName());
        if (icon != null || typeName != null) {
            return new PresentationTemplate(){

                @Override
                public Icon getIcon(Object o, int flags) {
                    return icon == null ? null : (Icon)icon.getValue();
                }

                @Override
                public String getName(Object o) {
                    return null;
                }

                @Override
                public String getTypeName() {
                    return typeName == null ? null : (String)typeName.getValue();
                }

                @Override
                public String getTypeName(Object o) {
                    return this.getTypeName();
                }
            };
        }
        return null;
    }

    private void walkSupers(Class aClass, Set<Class> classes2, Set<PresentationTemplate> templates) {
        if (!classes2.add(aClass)) {
            return;
        }
        ContainerUtil.addIfNotNull(templates, (Object)this.createPresentationTemplate(aClass));
        Class superClass = aClass.getSuperclass();
        if (superClass != null) {
            this.walkSupers(superClass, classes2, templates);
        }
        for (Class<?> intf : aClass.getInterfaces()) {
            this.walkSupers(intf, classes2, templates);
        }
    }

    static interface PresentationTemplate {
        @Nullable
        public Icon getIcon(Object var1, int var2);

        @Nullable
        public String getName(Object var1);

        @Nullable
        public String getTypeName();

        public String getTypeName(Object var1);
    }

    private static class AnnotationBasedTemplate
    extends PresentationProvider<Object>
    implements PresentationTemplate {
        private final Presentation myPresentation;
        private final Class<?> myClass;
        private final NullableLazyValue<Icon> myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                if (StringUtil.isEmpty((String)myPresentation.icon())) {
                    return null;
                }
                return IconLoader.getIcon((String)myPresentation.icon(), (Class)myClass);
            }
        };
        private final NullableLazyValue<PresentationProvider> myPresentationProvider = new NullableLazyValue<PresentationProvider>(){

            protected PresentationProvider compute() {
                Class aClass = myPresentation.provider();
                try {
                    return aClass == PresentationProvider.class ? null : (PresentationProvider)aClass.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };

        AnnotationBasedTemplate(Presentation presentation, Class<?> aClass) {
            this.myPresentation = presentation;
            this.myClass = aClass;
        }

        @Nullable
        public Icon getIcon(Object o) {
            return this.getIcon(o, 0);
        }

        @Override
        @Nullable
        public Icon getIcon(Object o, int flags) {
            if (o == null) {
                return (Icon)this.myIcon.getValue();
            }
            PresentationProvider provider = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider == null) {
                return (Icon)this.myIcon.getValue();
            }
            Icon icon = provider.getIcon(o);
            return icon == null ? (Icon)this.myIcon.getValue() : icon;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return StringUtil.isEmpty((String)this.myPresentation.typeName()) ? null : this.myPresentation.typeName();
        }

        @Override
        public String getTypeName(Object o) {
            String typeName;
            PresentationProvider provider = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider != null && (typeName = provider.getTypeName(o)) != null) {
                return typeName;
            }
            return this.getTypeName();
        }

        @Override
        @Nullable
        public String getName(Object o) {
            PresentationProvider namer = (PresentationProvider)this.myPresentationProvider.getValue();
            return namer == null ? null : namer.getName(o);
        }
    }

    public static class PresentationTemplateImpl
    extends ProviderBasedTemplate {
        public PresentationTemplateImpl(Presentation presentation, Class<?> aClass) {
            super(new AnnotationBasedTemplate(presentation, aClass));
        }
    }

    public static class ProviderBasedTemplate
    implements PresentationTemplate {
        private final PresentationProvider myProvider;

        public ProviderBasedTemplate(PresentationProvider provider) {
            this.myProvider = provider;
        }

        @Override
        @Nullable
        public Icon getIcon(Object o, int flags) {
            return this.myProvider instanceof PresentationTemplate ? ((PresentationTemplate)this.myProvider).getIcon(o, flags) : this.myProvider.getIcon(o);
        }

        @Override
        @Nullable
        public String getName(Object o) {
            return this.myProvider.getName(o);
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myProvider instanceof PresentationTemplate ? ((PresentationTemplate)this.myProvider).getTypeName() : null;
        }

        @Override
        public String getTypeName(Object o) {
            return this.myProvider.getTypeName(o);
        }
    }
}

