/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLauncherScriptAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreateLauncherScriptAction.class);
    private static final String CONTENTS = "/Contents";

    public static boolean isAvailable() {
        return SystemInfo.isUnix && !PathManager.isSnap();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(0);
        }
        boolean enabled = CreateLauncherScriptAction.isAvailable();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String message2;
        File target2;
        String home;
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(1);
        }
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        Project project2 = event.getProject();
        String title = ApplicationBundle.message((String)"launcher.script.title", (Object[])new Object[0]);
        String prompt = "<html>You can create a launcher script to enable opening files and projects in " + ApplicationNamesInfo.getInstance().getFullProductName() + " from the command line.<br>Please specify the name of the script and the path where it should be created:</html>";
        String path = Messages.showInputDialog((Project)project2, (String)prompt, (String)title, null, (String)CreateLauncherScriptAction.defaultScriptPath(), null);
        if (path == null) {
            return;
        }
        if (!path.startsWith("/") && (home = System.getenv("HOME")) != null && new File(home).isDirectory()) {
            path = path.startsWith("~") ? home + path.substring(1) : home + "/" + path;
        }
        if ((target2 = new File(path)).exists() && Messages.showOkCancelDialog((Project)project2, (String)(message2 = ApplicationBundle.message((String)"launcher.script.overwrite", (Object[])new Object[]{target2})), (String)title, (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        try {
            CreateLauncherScriptAction.createLauncherScript(target2.getAbsolutePath());
        }
        catch (Exception e) {
            CreateLauncherScriptAction.reportFailure(e, project2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLauncherScript(@NotNull String pathName) throws Exception {
        if (pathName == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(2);
        }
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        File scriptFile = CreateLauncherScriptAction.createLauncherScriptFile();
        try {
            File scriptTarget = new File(pathName);
            File scriptTargetDir = scriptTarget.getParentFile();
            assert (scriptTargetDir != null) : "path: " + pathName;
            if (!scriptTargetDir.exists() && !scriptTargetDir.mkdirs() || !scriptFile.renameTo(scriptTarget)) {
                String scriptTargetDirPath = scriptTargetDir.getCanonicalPath();
                String installationScriptSrc = "#!/bin/sh\nmkdir -p \"" + scriptTargetDirPath + "\"\ninstall -g 0 -o 0 \"" + scriptFile.getCanonicalPath() + "\" \"" + pathName + "\"";
                File installationScript = ExecUtil.createTempExecutableScript((String)"launcher_installer", (String)".sh", (String)installationScriptSrc);
                String prompt = ApplicationBundle.message((String)"launcher.script.sudo.prompt", (Object[])new Object[]{scriptTargetDirPath});
                ProcessOutput result2 = ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{installationScript.getPath()}), (String)prompt);
                int exitCode = result2.getExitCode();
                if (exitCode != 0) {
                    String message2 = "Launcher script creation failed with " + exitCode;
                    String output = result2.getStdout();
                    if (!StringUtil.isEmptyOrSpaces((String)output)) {
                        message2 = message2 + "\nOutput: " + output.trim();
                    }
                    throw new RuntimeException(message2);
                }
            }
        }
        finally {
            if (scriptFile.exists()) {
                FileUtil.delete((File)scriptFile);
            }
        }
    }

    public static void reportFailure(@NotNull Exception e, @Nullable Project project2) {
        if (e == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(3);
        }
        LOG.warn((Throwable)e);
        String message2 = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"Internal error");
        Notifications.Bus.notify((Notification)new Notification("System Messages", "Launcher Script Creation Failed", message2, NotificationType.ERROR), (Project)project2);
    }

    private static File createLauncherScriptFile() throws IOException, ExecutionException {
        String runPath;
        String string = runPath = SystemInfo.isMac ? StringUtil.trimEnd((String)PathManager.getHomePath(), (String)CONTENTS) : CreateDesktopEntryAction.getLauncherScript();
        if (runPath == null) {
            throw new IOException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{PathManager.getBinPath()}));
        }
        ClassLoader loader = CreateLauncherScriptAction.class.getClassLoader();
        assert (loader != null);
        Map variables = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"$CONFIG_PATH$", (Object)PathManager.getConfigPath()), (Pair[])new Pair[]{Pair.pair((Object)"$SYSTEM_PATH$", (Object)PathManager.getSystemPath()), Pair.pair((Object)"$RUN_PATH$", (Object)runPath)});
        String launcherContents = StringUtil.convertLineSeparators((String)ExecUtil.loadTemplate((ClassLoader)loader, (String)"launcher.py", (Map)variables));
        return ExecUtil.createTempExecutableScript((String)"launcher", (String)"", (String)launcherContents);
    }

    public static String defaultScriptPath() {
        String scriptName = ApplicationNamesInfo.getInstance().getDefaultLauncherName();
        if (StringUtil.isEmptyOrSpaces((String)scriptName)) {
            scriptName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        }
        return "/usr/local/bin/" + scriptName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateLauncherScriptAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createLauncherScript";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportFailure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

