/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project2, @Nullable PsiElement context, GotoFileModel model) {
        if (project2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(0);
        }
        super(context);
        this.myProject = project2;
        this.myModel = model;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        PsiFileSystemItem absolute;
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(4);
        }
        if ((absolute = this.getFileByAbsolutePath(pattern)) != null && !consumer.process((Object)absolute)) {
            return true;
        }
        if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
            pattern = pattern.substring(1);
        }
        if (!this.processItemsForPattern(base, pattern, everywhere, consumer, indicator)) {
            return false;
        }
        String fixed = FixingLayoutMatcher.fixLayout((String)pattern);
        return fixed == null || this.processItemsForPattern(base, fixed, everywhere, consumer, indicator);
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull Processor<Object> consumer, @NotNull ProgressIndicator indicator) {
        int index;
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(8);
        }
        String sanitized = GotoFileItemProvider.getSanitizedPattern(pattern, this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.myModel.processNames((Processor<String>)((Processor)grouper::processName), true);
        Ref hasSuggestions = Ref.create((Object)false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index))) {
            index = grouper.index;
            SuffixMatches group = grouper.nextGroup(base);
            if (group == null) break;
            if (group.processFiles(pattern, sanitized, everywhere, consumer, (Ref<Boolean>)hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, GotoFileModel model) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(9);
        }
        String string = GotoFileItemProvider.removeSlashes(StringUtil.replace((String)ChooseByNamePopup.getTransformedPattern(pattern, model), (String)"\\", (String)"/"));
        if (string == null) {
            GotoFileItemProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(11);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + StringUtil.replace((String)StringUtil.replace((String)pattern, (String)"\\", (String)"*\\*"), (String)"/", (String)"*/*")), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(12);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String removeSlashes(String s) {
        if (s.startsWith("/")) {
            String string = GotoFileItemProvider.removeSlashes(s.substring(1));
            if (string == null) {
                GotoFileItemProvider.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (s.endsWith("/")) {
            String string = GotoFileItemProvider.removeSlashes(s.substring(0, s.length() - 1));
            if (string == null) {
                GotoFileItemProvider.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            GotoFileItemProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(16);
        }
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile))) {
                return vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            }
        }
        return null;
    }

    @NotNull
    private List<PsiFileSystemItem> getFilesMatchingPath(@NotNull String pattern, boolean everywhere, MinusculeMatcher fullMatcher, List<String> fileNames, DirectoryPathMatcher dirMatcher, @NotNull ProgressIndicator indicator) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(18);
        }
        GlobalSearchScope scope = dirMatcher.narrowDown(FindSymbolParameters.searchScopeFor(this.myProject, everywhere));
        FindSymbolParameters parameters2 = new FindSymbolParameters(pattern, pattern, scope, null);
        ArrayList<PsiFileSystemItem> group = new ArrayList<PsiFileSystemItem>();
        HashMap<PsiFileSystemItem, Integer> qualifierMatchingDegrees = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> dirCloseness = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        for (String fileName : fileNames) {
            ProgressManager.checkCanceled();
            for (Object o : this.myModel.getElementsByName(fileName, parameters2, indicator)) {
                FList fragments;
                ProgressManager.checkCanceled();
                String fullName = this.myModel.getFullName(o);
                if (!(o instanceof PsiFileSystemItem) || fullName == null || (fragments = fullMatcher.matchingFragments(fullName = FileUtilRt.toSystemIndependentName((String)fullName))) == null || fragments.isEmpty()) continue;
                group.add((PsiFileSystemItem)o);
                qualifierMatchingDegrees.put((PsiFileSystemItem)o, -fullMatcher.matchingDegree(fullName, false, fragments));
                String matchingArea = fullName.substring(((TextRange)fragments.getHead()).getStartOffset(), ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset());
                dirCloseness.put((PsiFileSystemItem)o, StringUtil.countChars((CharSequence)matchingArea, (char)'/'));
                nesting.put((PsiFileSystemItem)o, StringUtil.countChars((CharSequence)fullName, (char)'/'));
            }
        }
        if (group.size() > 1) {
            Collections.sort(group, Comparator.comparing(f -> f instanceof PsiDirectory).thenComparing(qualifierMatchingDegrees::get).thenComparing(i -> i.getName().toLowerCase()).thenComparing(nesting::get).thenComparing(dirCloseness::get).thenComparing(this.getPathProximityComparator()).thenComparing(this.myModel::getFullName));
        }
        ArrayList<PsiFileSystemItem> arrayList = group;
        if (arrayList == null) {
            GotoFileItemProvider.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static int findMatchStartingPosition(String candidateName, String namePattern) {
        int namePos = candidateName.length();
        for (int i = namePattern.length(); i > 0; --i) {
            char c = namePattern.charAt(i - 1);
            if (!Character.isLetterOrDigit(c) || (namePos = StringUtil.lastIndexOfIgnoreCase((String)candidateName, (char)c, (int)(namePos - 1))) >= 0) continue;
            return i;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedPattern";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameMatcher";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSlashes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesMatchingPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processItemsForPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSanitizedPattern";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatcher";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileByAbsolutePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFilesMatchingPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames;
        final ProgressIndicator indicator;

        SuffixMatches(@NotNull String patternSuffix, ProgressIndicator indicator) {
            if (indicator == null) {
                SuffixMatches.$$$reportNull$$$0(0);
            }
            this.matchingNames = new ArrayList<MatchResult>();
            this.patternSuffix = patternSuffix;
            this.matcher = NameUtil.buildMatcher((String)("*" + patternSuffix), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            this.indicator = indicator;
        }

        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + '\'' + ", matchingNames=" + this.matchingNames + '}';
        }

        boolean matchName(@NotNull ChooseByNameBase base, String name2) {
            MatchResult result2;
            if (base == null) {
                SuffixMatches.$$$reportNull$$$0(1);
            }
            if ((result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name2)) != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull String pattern, String sanitizedPattern, boolean everywhere, Processor<? super PsiFileSystemItem> processor2, Ref<Boolean> hasSuggestions, DirectoryPathMatcher dirMatcher) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(2);
            }
            MinusculeMatcher fullMatcher = GotoFileItemProvider.getQualifiedNameMatcher(sanitizedPattern);
            List<List<String>> groups = this.groupByMatchingDegree(!pattern.startsWith("*"));
            for (List<String> group : groups) {
                List files = GotoFileItemProvider.this.getFilesMatchingPath(pattern, everywhere, fullMatcher, group, dirMatcher, this.indicator);
                if (!files.isEmpty()) {
                    hasSuggestions.set((Object)true);
                }
                if (ContainerUtil.process((List)files, processor2)) continue;
                return false;
            }
            return (Boolean)hasSuggestions.get() != false || everywhere || !this.hasSuggestionsOutsideProject(pattern, fullMatcher, groups, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, MinusculeMatcher fullMatcher, List<List<String>> groups, DirectoryPathMatcher dirMatcher) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(3);
            }
            return ContainerUtil.exists(groups, group -> {
                if (pattern == null) {
                    SuffixMatches.$$$reportNull$$$0(4);
                }
                return !GotoFileItemProvider.this.getFilesMatchingPath(pattern, true, fullMatcher, group, dirMatcher, this.indicator).isEmpty();
            });
        }

        private List<List<String>> groupByMatchingDegree(boolean preferStartMatches) {
            if (this.matchingNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<List<String>> groups = new ArrayList<List<String>>();
            Comparator comparator2 = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith((CharSequence)mr1.elementName, (CharSequence)this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith((CharSequence)mr2.elementName, (CharSequence)this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2, preferStartMatches);
            };
            Collections.sort(this.matchingNames, comparator2);
            ArrayList group = ContainerUtil.newArrayList((Object[])new String[]{this.matchingNames.get((int)0).elementName});
            for (int j = 1; j < this.matchingNames.size(); ++j) {
                MatchResult current = this.matchingNames.get(j);
                if (comparator2.compare(this.matchingNames.get(j - 1), current) == 0) {
                    group.add(current.elementName);
                    continue;
                }
                groups.add(group);
                group = ContainerUtil.newArrayList((Object[])new String[]{current.elementName});
            }
            groups.add(group);
            return groups;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasSuggestionsOutsideProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$hasSuggestionsOutsideProject$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NameGrouper {
        private final String namePattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            if (namePattern == null) {
                NameGrouper.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                NameGrouper.$$$reportNull$$$0(1);
            }
            this.index = 0;
            this.namePattern = namePattern;
            this.candidateNames = IntStreamEx.range((int)0, (int)namePattern.length()).mapToObj(__ -> new ArrayList()).toList();
            this.indicator = indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processName(String name2) {
            ProgressManager.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name2, this.namePattern);
            if (position < this.namePattern.length()) {
                List<String> list2;
                List<String> list3 = list2 = this.candidateNames.get(position);
                synchronized (list3) {
                    list2.add(name2);
                }
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(ChooseByNameBase base) {
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches = new SuffixMatches(this.namePattern.substring(this.index), this.indicator);
            for (String name2 : this.candidateNames.get(this.index)) {
                if (matches.matchName(base, name2) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name2);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namePattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/GotoFileItemProvider$NameGrouper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

