/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiDirectory;
import javax.swing.Icon;

public abstract class TemplateKindProvider {
    private static final ExtensionPointName<TemplateKindProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.javaee.templateKindProvider");

    public static void addAdditionalKinds(AnAction action, PsiDirectory dir, CreateFileFromTemplateDialog.Builder builder) {
        String id = ActionManager.getInstance().getId(action);
        for (TemplateKindProvider provider : (TemplateKindProvider[])Extensions.getExtensions(EP_NAME)) {
            for (Kind kind2 : provider.getAdditionalKinds(dir)) {
                builder.addKind(kind2.name, kind2.icon, kind2.templateName);
            }
        }
    }

    public abstract boolean isAvailable(Class<? extends AnAction> var1);

    public abstract Kind[] getAdditionalKinds(PsiDirectory var1);

    public static class Kind {
        public final String name;
        public final String templateName;
        public final Icon icon;

        public Kind(String name2, String templateName, Icon icon) {
            this.name = name2;
            this.templateName = templateName;
            this.icon = icon;
        }
    }
}

