/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Producer<Iterable<JComponent>> myProducer;

    @NotNull
    public static ActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(1);
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow), ToggleToolbarAction.createToolWindowAction(toolWindow, PropertiesComponent.getInstance((Project)project2)), Separator.getInstance()});
        if (defaultActionGroup == null) {
            ToggleToolbarAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Producer<Iterable<JComponent>> components) {
        if (id == null) {
            ToggleToolbarAction.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(4);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(5);
        }
        ToggleToolbarAction toggleToolbarAction = new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id), components);
        if (toggleToolbarAction == null) {
            ToggleToolbarAction.$$$reportNull$$$0(6);
        }
        return toggleToolbarAction;
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow, final @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(8);
        }
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                ContentManager contentManager;
                JComponent component = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible((Iterable<JComponent>)JBIterable.of((Object)component), ToggleToolbarAction.isToolbarVisible(toolWindow, properties));
                ContentManager contentManager2 = contentManager = component instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)component) : null;
                if (contentManager != null) {
                    contentManager.addContentManagerListener((ContentManagerListener)this);
                }
            }
        });
        ToggleToolbarAction toggleToolbarAction = new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow), (Producer<Iterable<JComponent>>)((Producer)() -> {
            if (toolWindow == null) {
                ToggleToolbarAction.$$$reportNull$$$0(34);
            }
            return JBIterable.of((Object)toolWindow.getContentManager().getComponent());
        }));
        if (toggleToolbarAction == null) {
            ToggleToolbarAction.$$$reportNull$$$0(9);
        }
        return toggleToolbarAction;
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(10);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(11);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow), properties, (Iterable<JComponent>)JBIterable.of((Object)toolWindow.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Iterable<JComponent> components, @Nullable Boolean visible) {
        if (id == null) {
            ToggleToolbarAction.$$$reportNull$$$0(12);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(13);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(14);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id), properties, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<JComponent> roots, boolean state) {
        if (roots == null) {
            ToggleToolbarAction.$$$reportNull$$$0(15);
        }
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots)) {
            JComponent c = toolbar.getComponent();
            c.setVisible(state);
            Container parent = c.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(16);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(17);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(18);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(19);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Producer<Iterable<JComponent>> producer) {
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(20);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(21);
        }
        if (producer == null) {
            ToggleToolbarAction.$$$reportNull$$$0(22);
        }
        super("Show Toolbar");
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(23);
        }
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars((Iterable)this.myProducer.produce()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.isSelected();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, (Iterable)this.myProducer.produce(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<JComponent> components, boolean visible) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(24);
        }
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(25);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(26);
        }
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(27);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(28);
        }
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        if (window == null) {
            ToggleToolbarAction.$$$reportNull$$$0(29);
        }
        String string = ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
        if (string == null) {
            ToggleToolbarAction.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull String s) {
        if (s == null) {
            ToggleToolbarAction.$$$reportNull$$$0(31);
        }
        String string = s + ".ShowToolbar";
        if (string == null) {
            ToggleToolbarAction.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<JComponent> roots) {
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class);
        if (jBIterable == null) {
            ToggleToolbarAction.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 16: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleToolbarGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindowAction";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowToolbarProperty";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateToolbars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToggleToolbarGroup";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisible";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isToolbarVisible";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisibleImpl";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedImpl";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getShowToolbarProperty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createToolWindowAction$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        public OptionsGroup(ToolWindow toolWindow) {
            super("View Options", true);
            this.myToolWindow = toolWindow;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty((ActionGroup)this, (AnActionEvent)e, (boolean)LaterInvocator.isInModalContext()));
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null) {
                if (EMPTY_ARRAY == null) {
                    OptionsGroup.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            List result2 = ContainerUtil.newSmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars((Iterable)JBIterable.of((Object)contentComponent))) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem((List)result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List actions = toolbar.getActions();
                for (AnAction action : actions) {
                    if (action instanceof ToggleAction && !result2.contains(action)) {
                        result2.add(action);
                        continue;
                    }
                    if (!(action instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem((List)result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup2 = result2.size() > 3;
            this.setPopup(popup2);
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
            if (anActionArray == null) {
                OptionsGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup", "getChildren"));
        }
    }
}

