/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.PlatformIcons;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenUrlHyperlinkInfo
implements HyperlinkWithPopupMenuInfo {
    private final String url;
    private final WebBrowser browser;
    private final Condition<WebBrowser> browserCondition;

    public OpenUrlHyperlinkInfo(@NotNull String url) {
        if (url == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(0);
        }
        this(url, (Condition<WebBrowser>)Conditions.alwaysTrue(), null);
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @Nullable WebBrowser browser) {
        if (url == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(1);
        }
        this(url, (Condition<WebBrowser>)Conditions.alwaysTrue(), browser);
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<WebBrowser> browserCondition) {
        if (url == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(2);
        }
        if (browserCondition == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(3);
        }
        this(url, browserCondition, null);
    }

    private OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<WebBrowser> browserCondition, @Nullable WebBrowser browser) {
        if (url == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(4);
        }
        if (browserCondition == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(5);
        }
        this.url = url;
        this.browserCondition = browserCondition;
        this.browser = browser;
    }

    @Override
    public ActionGroup getPopupMenuGroup(@NotNull MouseEvent event) {
        if (event == null) {
            OpenUrlHyperlinkInfo.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (final WebBrowser browser : WebBrowserManager.getInstance().getActiveBrowsers()) {
            if (!this.browserCondition.value((Object)browser)) continue;
            group.add(new AnAction("Open in " + browser.getName(), "Open URL in " + browser.getName(), browser.getIcon()){

                public void actionPerformed(AnActionEvent e) {
                    BrowserLauncher.getInstance().browse(OpenUrlHyperlinkInfo.this.url, browser, e.getProject());
                }
            });
        }
        group.add(new AnAction("Copy URL", "Copy URL to clipboard", PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(OpenUrlHyperlinkInfo.this.url));
            }
        });
        return group;
    }

    public void navigate(Project project2) {
        BrowserLauncher.getInstance().browse(this.url, this.browser, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserCondition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/browsers/OpenUrlHyperlinkInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupMenuGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

