/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTemplate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.DefaultTemplate");
    private final String myName;
    private final String myExtension;
    private final URL myTemplateURL;
    @Nullable
    private final URL myDescriptionURL;
    private final String myText;
    private final String myDescriptionText;

    public DefaultTemplate(@NotNull String name2, @NotNull String extension, @NotNull URL templateURL, @Nullable URL descriptionURL) {
        if (name2 == null) {
            DefaultTemplate.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            DefaultTemplate.$$$reportNull$$$0(1);
        }
        if (templateURL == null) {
            DefaultTemplate.$$$reportNull$$$0(2);
        }
        this.myName = name2;
        this.myExtension = extension;
        this.myTemplateURL = templateURL;
        this.myDescriptionURL = descriptionURL;
        this.myText = DefaultTemplate.loadText(templateURL);
        this.myDescriptionText = descriptionURL != null ? DefaultTemplate.loadText(descriptionURL) : "";
    }

    private static String loadText(URL url) {
        String text2 = "";
        try {
            text2 = StringUtil.convertLineSeparators((String)UrlUtil.loadText(url));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text2;
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public String getExtension() {
        return this.myExtension;
    }

    public URL getTemplateURL() {
        return this.myTemplateURL;
    }

    @Nullable
    public URL getDescriptionURL() {
        return this.myDescriptionURL;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDescriptionText() {
        String string = this.myDescriptionText;
        if (string == null) {
            DefaultTemplate.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateURL";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/DefaultTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/DefaultTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

