/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExportableFileTemplateSettings", storages={@Storage(value="file.template.settings.xml")})
public class FileTemplateSettings
extends FileTemplatesLoader
implements PersistentStateComponent<Element> {
    public static final String EXPORTABLE_SETTINGS_FILE = "file.template.settings.xml";
    private static final String ELEMENT_TEMPLATE = "template";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_REFORMAT = "reformat";
    private static final String ATTRIBUTE_LIVE_TEMPLATE = "live-template-enabled";
    private static final String ATTRIBUTE_ENABLED = "enabled";

    public FileTemplateSettings(@NotNull FileTypeManagerEx typeManager, @Nullable Project project2) {
        if (typeManager == null) {
            FileTemplateSettings.$$$reportNull$$$0(0);
        }
        super(typeManager, project2);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("fileTemplateSettings");
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = null;
            for (FileTemplateBase template : manager.getAllTemplates(true)) {
                boolean shouldSave;
                boolean bl = shouldSave = !template.isReformatCode() || template.isLiveTemplateEnabled() != template.isLiveTemplateEnabledByDefault();
                if (template instanceof BundledFileTemplate) {
                    shouldSave |= !((BundledFileTemplate)template).isEnabled();
                }
                if (!shouldSave) continue;
                Element templateElement = new Element(ELEMENT_TEMPLATE);
                templateElement.setAttribute(ATTRIBUTE_NAME, template.getQualifiedName());
                templateElement.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isReformatCode()));
                templateElement.setAttribute(ATTRIBUTE_LIVE_TEMPLATE, Boolean.toString(template.isLiveTemplateEnabled()));
                if (template instanceof BundledFileTemplate) {
                    templateElement.setAttribute(ATTRIBUTE_ENABLED, Boolean.toString(((BundledFileTemplate)template).isEnabled()));
                }
                if (templatesGroup == null) {
                    templatesGroup = new Element(FileTemplateSettings.getXmlElementGroupName(manager));
                    element.addContent(templatesGroup);
                }
                templatesGroup.addContent(templateElement);
            }
        }
        return element;
    }

    public void loadState(Element state) {
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = state.getChild(FileTemplateSettings.getXmlElementGroupName(manager));
            if (templatesGroup == null) continue;
            for (Element child : templatesGroup.getChildren(ELEMENT_TEMPLATE)) {
                String qName = child.getAttributeValue(ATTRIBUTE_NAME);
                FileTemplateBase template = manager.getTemplate(qName);
                if (template == null) continue;
                template.setReformatCode(Boolean.parseBoolean(child.getAttributeValue(ATTRIBUTE_REFORMAT)));
                template.setLiveTemplateEnabled(Boolean.parseBoolean(child.getAttributeValue(ATTRIBUTE_LIVE_TEMPLATE)));
                if (!(template instanceof BundledFileTemplate)) continue;
                ((BundledFileTemplate)template).setEnabled(Boolean.parseBoolean(child.getAttributeValue(ATTRIBUTE_ENABLED, "true")));
            }
        }
    }

    private static String getXmlElementGroupName(FTManager manager) {
        return manager.getName().toLowerCase(Locale.US) + "_templates";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeManager", "com/intellij/ide/fileTemplates/impl/FileTemplateSettings", "<init>"));
    }
}

