/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase");
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(@NotNull LanguageExtension<HierarchyProvider> extension) {
        if (extension == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(0);
        }
        this.myExtension = extension;
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        HierarchyProvider provider = this.getProvider(e);
        if (provider == null) {
            return;
        }
        PsiElement target2 = provider.getTarget(dataContext);
        if (target2 == null) {
            return;
        }
        BrowseHierarchyActionBase.createAndAddToPanel(project2, provider, target2);
    }

    @NotNull
    public static HierarchyBrowser createAndAddToPanel(@NotNull Project project2, @NotNull HierarchyProvider provider, @NotNull PsiElement target2) {
        Content content;
        if (project2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(3);
        }
        HierarchyBrowser hierarchyBrowser = provider.createHierarchyBrowser(target2);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project2);
        ContentManager contentManager = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && !selectedContent.isPinned()) {
            content = selectedContent;
            JComponent component = content.getComponent();
            if (component instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)component));
            }
            content.setComponent(hierarchyBrowser.getComponent());
        } else {
            content = ContentFactory.SERVICE.getInstance().createContent(hierarchyBrowser.getComponent(), null, true);
            contentManager.addContent(content);
        }
        contentManager.setSelectedContent(content);
        hierarchyBrowser.setContent(content);
        Runnable runnable2 = () -> {
            if (provider == null) {
                BrowseHierarchyActionBase.$$$reportNull$$$0(7);
            }
            if (hierarchyBrowser instanceof HierarchyBrowserBase && ((HierarchyBrowserBase)hierarchyBrowser).isDisposed()) {
                return;
            }
            provider.browserActivated(hierarchyBrowser);
        };
        ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.HIERARCHY).activate(runnable2);
        HierarchyBrowser hierarchyBrowser2 = hierarchyBrowser;
        if (hierarchyBrowser2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(4);
        }
        return hierarchyBrowser2;
    }

    public void update(AnActionEvent e) {
        if (!this.myExtension.hasAnyExtensions()) {
            e.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e);
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setVisible(true);
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e) {
        HierarchyProvider provider = this.getProvider(e);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using provider " + provider);
        }
        if (provider == null) {
            return false;
        }
        PsiElement target2 = provider.getTarget(e.getDataContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + target2);
        }
        return target2 != null;
    }

    @Nullable
    private HierarchyProvider getProvider(AnActionEvent e) {
        return BrowseHierarchyActionBase.findProvider(this.myExtension, (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT), (PsiFile)e.getData(CommonDataKeys.PSI_FILE), e.getDataContext());
    }

    @Nullable
    public static HierarchyProvider findProvider(@NotNull LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile, @NotNull DataContext dataContext) {
        HierarchyProvider provider;
        if (extension == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(6);
        }
        if ((provider = BrowseHierarchyActionBase.findBestHierarchyProvider(extension, psiElement, dataContext)) == null) {
            return BrowseHierarchyActionBase.findBestHierarchyProvider(extension, (PsiElement)psiFile, dataContext);
        }
        return provider;
    }

    @Nullable
    public static HierarchyProvider findBestHierarchyProvider(LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement element, DataContext dataContext) {
        if (element == null) {
            return null;
        }
        List providers2 = extension.allForLanguage(element.getLanguage());
        for (HierarchyProvider provider : providers2) {
            PsiElement target2 = provider.getTarget(dataContext);
            if (target2 == null) continue;
            return provider;
        }
        return (HierarchyProvider)ContainerUtil.getFirstItem((List)providers2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAddToPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddToPanel";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAndAddToPanel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

