/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.hierarchy.method.MethodHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.method.MethodHierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class MethodHierarchyBrowser
extends MethodHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.method.MethodHierarchyBrowser");

    public MethodHierarchyBrowser(Project project2, PsiMethod method) {
        super(project2, (PsiElement)method);
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            MethodHierarchyBrowser.$$$reportNull$$$0(0);
        }
        JTree tree = this.createTree(false);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MethodHierarchyPopupMenu");
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)group, (String)"MethodHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        BaseOnThisMethodAction action = new BaseOnThisMethodAction();
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction("MethodHierarchy").getShortcutSet(), tree);
        trees.put(METHOD_TYPE, tree);
    }

    @Override
    protected JPanel createLegendPanel() {
        return MethodHierarchyBrowser.createStandardLegendPanel(IdeBundle.message((String)"hierarchy.legend.method.is.defined.in.class", (Object[])new Object[0]), IdeBundle.message((String)"hierarchy.legend.method.defined.in.superclass", (Object[])new Object[0]), IdeBundle.message((String)"hierarchy.legend.method.should.be.defined", (Object[])new Object[0]));
    }

    @Override
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            MethodHierarchyBrowser.$$$reportNull$$$0(1);
        }
        if (descriptor2 instanceof MethodHierarchyNodeDescriptor) {
            return ((MethodHierarchyNodeDescriptor)descriptor2).getTargetElement();
        }
        return null;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MethodHierarchyBrowser.$$$reportNull$$$0(2);
        }
        return psiElement instanceof PsiMethod;
    }

    @Override
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            MethodHierarchyBrowser.$$$reportNull$$$0(3);
        }
        if (psiElement == null) {
            MethodHierarchyBrowser.$$$reportNull$$$0(4);
        }
        if (!METHOD_TYPE.equals(typeName)) {
            LOG.error("unexpected type: " + typeName);
            return null;
        }
        return new MethodHierarchyTreeStructure(this.myProject, (PsiMethod)psiElement);
    }

    @Override
    protected Comparator<NodeDescriptor> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    public PsiMethod getBaseMethod() {
        HierarchyTreeBuilder builder = this.getCurrentBuilder();
        MethodHierarchyTreeStructure treeStructure = (MethodHierarchyTreeStructure)builder.getTreeStructure();
        assert (treeStructure != null) : builder;
        return treeStructure.getBaseMethod();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/hierarchy/method/MethodHierarchyBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTrees";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createHierarchyTreeStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class BaseOnThisMethodAction
    extends MethodHierarchyBrowserBase.BaseOnThisMethodAction {
    }
}

