/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectSubViewSelectInTarget;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchProjectViewPane;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewSelectInTarget
extends SelectInTargetPsiWrapper
implements CompositeSelectInTarget {
    private String mySubId;

    protected ProjectViewSelectInTarget(Project project2) {
        super(project2);
    }

    @Override
    protected final void select(Object selector2, VirtualFile virtualFile, boolean requestFocus) {
        ProjectViewSelectInTarget.select(this.myProject, selector2, this.getMinorViewId(), this.mySubId, virtualFile, requestFocus);
    }

    @NotNull
    public static ActionCallback select(@NotNull Project project2, Object toSelect2, @Nullable String viewId, @Nullable String subviewId, VirtualFile virtualFile, boolean requestFocus) {
        if (project2 == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(0);
        }
        ActionCallback result2 = new ActionCallback();
        ProjectView projectView = ProjectView.getInstance(project2);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractProjectViewPane pane = projectView.getProjectViewPaneById("ProjectPane");
            pane.select(toSelect2, virtualFile, requestFocus);
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                ProjectViewSelectInTarget.$$$reportNull$$$0(1);
            }
            return actionCallback;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow projectViewToolWindow = windowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
        Runnable runnable2 = () -> {
            Runnable r = () -> projectView.selectCB(toSelect2, virtualFile, requestFocus).notify(result2);
            projectView.changeViewCB((String)ObjectUtils.chooseNotNull((Object)viewId, (Object)"ProjectPane"), subviewId).doWhenProcessed(r);
        };
        if (requestFocus) {
            projectViewToolWindow.activate(runnable2, true);
        } else {
            projectViewToolWindow.show(runnable2);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        if (context == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(3);
        }
        ArrayList<SelectInTarget> result2 = new ArrayList<SelectInTarget>();
        AbstractProjectViewPane pane = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        int index = 0;
        for (String subId : pane.getSubIds()) {
            result2.add(new ProjectSubViewSelectInTarget(this, subId, index++));
        }
        ArrayList<SelectInTarget> arrayList = result2;
        if (arrayList == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return false;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (vFile == null || !vFile.isValid()) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return index.getContentRootForFile(vFile, false) != null || index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile) || Comparing.equal((Object)vFile.getParent(), (Object)this.myProject.getBaseDir()) || ScratchProjectViewPane.isScratchesMergedIntoProjectTab() && vFile.getFileType() == ScratchFileType.INSTANCE;
    }

    public String getSubIdPresentableName(String subId) {
        AbstractProjectViewPane pane = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        return pane.getPresentableSubIdName(subId);
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        PsiUtilCore.ensureValid((PsiElement)element);
        PsiElement toSelect2 = null;
        for (TreeStructureProvider provider : this.getProvidersDumbAware()) {
            if (provider instanceof SelectableTreeStructureProvider) {
                toSelect2 = ((SelectableTreeStructureProvider)provider).getTopLevelElement(element);
            }
            if (toSelect2 == null) continue;
            if (toSelect2.isValid()) break;
            throw new PsiInvalidElementAccessException(toSelect2, "Returned by " + provider);
        }
        if ((toSelect2 = ProjectViewSelectInTarget.findElementToSelect(element, toSelect2)) != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)toSelect2);
            this.select(toSelect2, virtualFile, requestFocus);
        }
    }

    private TreeStructureProvider[] getProvidersDumbAware() {
        Object[] allProviders = (TreeStructureProvider[])Extensions.getExtensions((ExtensionPointName)TreeStructureProvider.EP_NAME, (AreaInstance)this.myProject);
        List dumbAware = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(allProviders);
        return dumbAware.toArray(new TreeStructureProvider[dumbAware.size()]);
    }

    public final String getToolWindowId() {
        return ToolWindowId.PROJECT_VIEW;
    }

    public final void setSubId(String subId) {
        this.mySubId = subId;
    }

    public final String getSubId() {
        return this.mySubId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/ProjectViewSelectInTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/ProjectViewSelectInTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

