/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = ContainerUtil.set((Object[])new String[]{"kotlin.sequences.Sequence", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.reflect.KDeclarationContainer"});

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents2, PluginId pluginId, String version, File pluginRoot) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name2, boolean resolve2) throws ClassNotFoundException {
        Class c;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if ((c = this.tryLoadingClass(name2, resolve2, null)) == null) {
            throw new ClassNotFoundException(name2 + " " + (Object)((Object)this));
        }
        return c;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name2, boolean resolve2, @Nullable Set<ClassLoader> visited) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        Class c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name2)) {
            c = this.loadClassInsideSelf(name2);
        }
        if (c == null) {
            c = this.loadClassFromParents(name2, visited);
        }
        if (c != null) {
            if (resolve2) {
                this.resolveClass(c);
            }
            return c;
        }
        return null;
    }

    private static boolean mustBeLoadedByPlatform(String className) {
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    @Nullable
    private Class loadClassFromParents(String name2, Set<ClassLoader> visited) {
        for (ClassLoader parent : this.myParents) {
            if (visited == null) {
                visited = ContainerUtilRt.newHashSet((Object[])new ClassLoader[]{this});
            }
            if (!visited.add((ClassLoader)parent)) continue;
            if (parent instanceof PluginClassLoader) {
                Class c = ((PluginClassLoader)((Object)parent)).tryLoadingClass(name2, false, visited);
                if (c == null) continue;
                return c;
            }
            try {
                return parent.loadClass(name2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(@NotNull String name2) {
        Class c;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if ((c = this.findLoadedClass(name2)) != null) {
            return c;
        }
        try {
            c = this._findClass(name2);
        }
        catch (IncompatibleClassChangeError | UnsupportedClassVersionError e) {
            throw new PluginException("While loading class " + name2 + ": " + e.getMessage(), (Throwable)e, this.myPluginId);
        }
        if (c != null) {
            PluginManagerCore.addPluginClass(this.myPluginId);
        }
        return c;
    }

    public URL findResource(String name2) {
        URL resource = super.findResource(name2);
        if (resource != null) {
            return resource;
        }
        for (ClassLoader parent : this.myParents) {
            URL parentResource = parent.getResource(name2);
            if (parentResource == null) continue;
            return parentResource;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name2) {
        InputStream stream = super.getResourceAsStream(name2);
        if (stream != null) {
            return stream;
        }
        for (ClassLoader parent : this.myParents) {
            InputStream inputStream = parent.getResourceAsStream(name2);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name2) throws IOException {
        Enumeration[] resources = new Enumeration[this.myParents.length + 1];
        resources[0] = super.findResources(name2);
        for (int idx = 0; idx < this.myParents.length; ++idx) {
            resources[idx + 1] = this.myParents[idx].getResources(name2);
        }
        return new DeepEnumeration(resources);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        this.myLibDirectories.addAll(libDirectories);
    }

    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "] " + super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadingClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClassInsideSelf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex;

        DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }
}

