/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkSourceRootAction
extends MarkRootActionBase {
    private static final Logger LOG = Logger.getInstance(MarkSourceRootAction.class);
    private final JpsModuleSourceRootType<?> myRootType;

    public MarkSourceRootAction(@NotNull JpsModuleSourceRootType<?> type2) {
        if (type2 == null) {
            MarkSourceRootAction.$$$reportNull$$$0(0);
        }
        this.myRootType = type2;
        Presentation presentation = this.getTemplatePresentation();
        ModuleSourceRootEditHandler<?> editHandler = ModuleSourceRootEditHandler.getEditHandler(type2);
        LOG.assertTrue(editHandler != null);
        presentation.setIcon(editHandler.getRootIcon());
        presentation.setText(editHandler.getFullRootTypeName());
        presentation.setDescription(ProjectBundle.message((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getFullRootTypeName().toLowerCase(Locale.getDefault())}));
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            MarkSourceRootAction.$$$reportNull$$$0(1);
        }
        if (entry == null) {
            MarkSourceRootAction.$$$reportNull$$$0(2);
        }
        entry.addSourceFolder(vFile, this.myRootType);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        ModuleType moduleType;
        if (selection == null) {
            MarkSourceRootAction.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            MarkSourceRootAction.$$$reportNull$$$0(4);
        }
        if (!(moduleType = ModuleType.get((Module)module2)).isSupportedRootType(this.myRootType) || ModuleSourceRootEditHandler.getEditHandler(this.myRootType) == null || selection.myHaveSelectedFilesUnderSourceRoots && !moduleType.isMarkInnerSupportedFor(this.myRootType)) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            if (this.myRootType.equals((Object)root.getRootType())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkSourceRootAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

