/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModulesToGroupAction
extends AnAction {
    protected final ModuleGroup myModuleGroup;

    public MoveModulesToGroupAction(ModuleGroup moduleGroup, String title) {
        super(title);
        this.myModuleGroup = moduleGroup;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = this.getTemplatePresentation();
        DataContext dataContext = e.getDataContext();
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        e.getPresentation().setEnabledAndVisible(modules != null);
        if (modules != null) {
            String description = IdeBundle.message((String)"message.move.modules.to.group", (Object[])new Object[]{MoveModulesToGroupAction.whatToMove(modules), this.myModuleGroup.presentableText()});
            presentation.setDescription(description);
        }
    }

    protected static String whatToMove(@NotNull Module[] modules) {
        if (modules == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(0);
        }
        return modules.length == 1 ? IdeBundle.message((String)"message.module", (Object[])new Object[]{modules[0].getName()}) : IdeBundle.message((String)"message.modules", (Object[])new Object[0]);
    }

    public void actionPerformed(AnActionEvent e) {
        Module[] modules = (Module[])e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        MoveModulesToGroupAction.doMove(modules, this.myModuleGroup, e.getDataContext());
    }

    public static void doMove(@NotNull Module[] modules, ModuleGroup group, @Nullable DataContext dataContext) {
        if (modules == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(1);
        }
        Project project2 = modules[0].getProject();
        for (Module module2 : modules) {
            ModifiableModuleModel model;
            ModifiableModuleModel modifiableModuleModel = model = dataContext != null ? (ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext) : null;
            if (model != null) {
                model.setModuleGroupPath(module2, group == null ? null : group.getGroupPath());
                continue;
            }
            ModuleManagerImpl.getInstanceImpl(project2).setModuleGroupPath(module2, group == null ? null : group.getGroupPath());
        }
        AbstractProjectViewPane pane = ProjectView.getInstance(project2).getCurrentProjectViewPane();
        if (pane != null) {
            pane.updateFromRoot(true);
        }
        if (!ProjectSettingsService.getInstance(project2).processModulesMoved(modules, group) && pane != null) {
            if (group != null) {
                pane.selectModuleGroup(group, true);
            } else {
                pane.selectModule(modules[0], true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "modules";
        objectArray2[1] = "com/intellij/ide/projectView/actions/MoveModulesToGroupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "whatToMove";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

