/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class MoveModulesToSubGroupAction
extends MoveModulesToGroupAction {
    public MoveModulesToSubGroupAction(ModuleGroup moduleGroup) {
        super(moduleGroup, moduleGroup == null ? IdeBundle.message((String)"action.move.module.new.top.level.group", (Object[])new Object[0]) : IdeBundle.message((String)"action.move.module.to.new.sub.group", (Object[])new Object[0]));
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY) != null);
        String description = IdeBundle.message((String)"action.description.create.new.module.group", (Object[])new Object[0]);
        presentation.setDescription(description);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        List newGroup;
        DataContext dataContext = e.getDataContext();
        Module[] modules = (Module[])e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        if (this.myModuleGroup != null) {
            String message2 = IdeBundle.message((String)"prompt.specify.name.of.module.subgroup", (Object[])new Object[]{this.myModuleGroup.presentableText(), MoveModulesToSubGroupAction.whatToMove(modules)});
            String subgroup = Messages.showInputDialog((String)message2, (String)IdeBundle.message((String)"title.module.sub.group", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (subgroup == null || "".equals(subgroup.trim())) {
                return;
            }
            newGroup = ContainerUtil.append(this.myModuleGroup.getGroupPathList(), (Object[])new String[]{subgroup});
        } else {
            String message3 = IdeBundle.message((String)"prompt.specify.module.group.name", (Object[])new Object[]{MoveModulesToSubGroupAction.whatToMove(modules)});
            String group = Messages.showInputDialog((String)message3, (String)IdeBundle.message((String)"title.module.group", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (group == null || "".equals(group.trim())) {
                return;
            }
            newGroup = Collections.singletonList(group);
        }
        MoveModulesToSubGroupAction.doMove(modules, new ModuleGroup(newGroup), dataContext);
    }
}

